/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.common.messages;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tomcat.maven.common.messages.MessagesProvider;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MessagesProvider.class)
public class DefaultMessagesProvider
implements MessagesProvider {
    private ResourceBundle messages;

    public DefaultMessagesProvider() {
        String packageName = this.getClass().getPackage().getName();
        this.messages = ResourceBundle.getBundle(packageName + ".messages");
    }

    public ResourceBundle getResourceBundle() {
        return this.messages;
    }

    public String getMessage(String key) {
        try {
            return this.getResourceBundle().getString(key);
        }
        catch (NullPointerException exception) {
            return "???" + key + "???";
        }
        catch (MissingResourceException exception) {
            return "???" + key + "???";
        }
        catch (ClassCastException exception) {
            return "???" + key + "???";
        }
    }

    public String getMessage(String key, Object ... params) {
        return MessageFormat.format(this.getMessage(key), params);
    }
}

