/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.SyntheticRepository;
import org.apache.commons.io.IOUtils;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.Util;

public class ClassConverter
implements Converter,
ClassFileTransformer {
    private static final Logger logger;
    private static final StringManager sm;
    protected final EESpecProfile profile;

    public ClassConverter() {
        this(EESpecProfiles.TOMCAT);
    }

    public ClassConverter(EESpecProfile profile) {
        this.profile = profile;
    }

    public String toString() {
        return ClassConverter.class.getCanonicalName() + '[' + this.profile.toString() + ']';
    }

    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return "class".equals(extension);
    }

    @Override
    public boolean convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        return this.convertInternal(path, src, dest, profile, null);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(classfileBuffer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.convertInternal(className, inputStream, outputStream, this.profile, loader);
        }
        catch (IOException e) {
            throw new IllegalClassFormatException(e.getLocalizedMessage());
        }
        return outputStream.toByteArray();
    }

    protected boolean convertInternal(String path, InputStream src, OutputStream dest, EESpecProfile profile, ClassLoader loader) throws IOException {
        byte[] classBytes = IOUtils.toByteArray((InputStream)src);
        ClassParser parser = new ClassParser((InputStream)new ByteArrayInputStream(classBytes), "unknown");
        JavaClass javaClass = parser.parse();
        boolean converted = false;
        Constant[] constantPool = javaClass.getConstantPool().getConstantPool();
        for (int i = 0; i < constantPool.length; ++i) {
            ConstantUtf8 c;
            String str;
            String newString;
            if (!(constantPool[i] instanceof ConstantUtf8) || (newString = profile.convert(str = (c = (ConstantUtf8)constantPool[i]).getBytes())) == str) continue;
            if (loader != null) {
                String[] split;
                for (String current : split = newString.split(";|<")) {
                    int pos = current.indexOf(profile.getTarget() + "/");
                    boolean dotMode = false;
                    if (pos < 0) {
                        pos = current.indexOf(profile.getTarget() + ".");
                        dotMode = true;
                    }
                    if (pos < 0) continue;
                    String resourceName = current.substring(pos);
                    if (dotMode) {
                        resourceName = resourceName.replace('.', '/');
                    }
                    if (loader.getResource(resourceName = resourceName + ".class") != null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, sm.getString("classConverter.skipName", profile.getSource(), current.substring(pos).replace('/', '.')));
                    }
                    String originalFragment = dotMode ? current.replace(profile.getTarget() + ".", profile.getSource() + ".") : current.replace(profile.getTarget() + "/", profile.getSource() + "/");
                    newString = newString.replace(current, originalFragment);
                }
            }
            c = new ConstantUtf8(newString);
            constantPool[i] = c;
            converted = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            if (converted) {
                logger.log(Level.FINE, sm.getString("classConverter.converted", path.replace('/', '.')));
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, sm.getString("classConverter.noConversion", path.replace('/', '.')));
            }
        }
        if (converted) {
            javaClass.dump(dest);
        } else {
            IOUtils.writeChunked((byte[])classBytes, (OutputStream)dest);
        }
        return converted;
    }

    static {
        SyntheticRepository.getInstance();
        logger = Logger.getLogger(ClassConverter.class.getCanonicalName());
        sm = StringManager.getManager(ClassConverter.class);
    }
}

