/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.Util;

public class ClassConverter
implements Converter,
ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(ClassConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(ClassConverter.class);

    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return "class".equals(extension);
    }

    @Override
    public void convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        ClassParser parser = new ClassParser(src, "unknown");
        JavaClass javaClass = parser.parse();
        boolean converted = false;
        Constant[] constantPool = javaClass.getConstantPool().getConstantPool();
        for (int i = 0; i < constantPool.length; ++i) {
            ConstantUtf8 c;
            String str;
            String newString;
            if (!(constantPool[i] instanceof ConstantUtf8) || (newString = profile.convert(str = (c = (ConstantUtf8)constantPool[i]).getBytes())) == str) continue;
            c = new ConstantUtf8(profile.convert(str));
            constantPool[i] = c;
            converted = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            if (converted) {
                logger.log(Level.FINE, sm.getString("classConverter.converted", path));
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, sm.getString("classConverter.noConversion", path));
            }
        }
        javaClass.dump(dest);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(classfileBuffer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.convert(className, inputStream, outputStream, EESpecProfile.TOMCAT);
        }
        catch (IOException e) {
            throw new IllegalClassFormatException(e.getLocalizedMessage());
        }
        return outputStream.toByteArray();
    }
}

