/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.InvalidParameterException;
import org.apache.tomcat.util.res.StringManager;

public final class Parameters {
    private static final Log log = LogFactory.getLog(Parameters.class);
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.http");
    private final Map<String, ArrayList<String>> paramHashValues = new LinkedHashMap<String, ArrayList<String>>();
    private boolean didQueryParameters = false;
    private MessageBytes queryMB;
    private UDecoder urlDec;
    private final MessageBytes decodedQuery = MessageBytes.newInstance();
    private Charset charset = StandardCharsets.ISO_8859_1;
    private Charset queryStringCharset = StandardCharsets.UTF_8;
    private int limit = -1;
    private int parameterCount = 0;
    private final ByteChunk tmpName = new ByteChunk();
    private final ByteChunk tmpValue = new ByteChunk();
    private final ByteChunk origName = new ByteChunk();
    private final ByteChunk origValue = new ByteChunk();
    private static final Charset DEFAULT_BODY_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Charset DEFAULT_URI_CHARSET = StandardCharsets.UTF_8;

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            charset = DEFAULT_BODY_CHARSET;
        }
        this.charset = charset;
        if (log.isTraceEnabled()) {
            log.trace("Set encoding to " + charset.name());
        }
    }

    public void setQueryStringCharset(Charset queryStringCharset) {
        if (queryStringCharset == null) {
            queryStringCharset = DEFAULT_URI_CHARSET;
        }
        this.queryStringCharset = queryStringCharset;
        if (log.isTraceEnabled()) {
            log.trace("Set query string encoding to " + queryStringCharset.name());
        }
    }

    public int size() {
        return this.parameterCount;
    }

    public void recycle() {
        this.parameterCount = 0;
        this.paramHashValues.clear();
        this.didQueryParameters = false;
        this.charset = DEFAULT_BODY_CHARSET;
        this.decodedQuery.recycle();
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public Enumeration<String> getParameterNames() {
        this.handleQueryParameters();
        return Collections.enumeration(this.paramHashValues.keySet());
    }

    public String getParameter(String name) {
        this.handleQueryParameters();
        ArrayList<String> values = this.paramHashValues.get(name);
        if (values != null) {
            if (values.isEmpty()) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Decoding query " + String.valueOf(this.decodedQuery) + " " + this.queryStringCharset.name());
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            log.error(sm.getString("parameters.copyFail"), e);
        }
        this.processParameters(this.decodedQuery, this.queryStringCharset);
    }

    public void addParameter(String key, String value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        if (this.limit > -1 && this.parameterCount >= this.limit) {
            throw new InvalidParameterException(sm.getString("parameters.maxCountFail", this.limit));
        }
        ++this.parameterCount;
        this.paramHashValues.computeIfAbsent(key, k -> new ArrayList(1)).add(value);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.charset);
    }

    private void processParameters(byte[] bytes, int start, int len, Charset charset) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("parameters.bytes", new String(bytes, start, len, DEFAULT_BODY_CHARSET)));
        }
        int pos = start;
        int end = start + len;
        while (pos < end) {
            String message;
            int nameStart = pos;
            int nameEnd = -1;
            int valueStart = -1;
            int valueEnd = -1;
            boolean parsingName = true;
            boolean decodeName = false;
            boolean decodeValue = false;
            boolean parameterComplete = false;
            do {
                switch (bytes[pos]) {
                    case 61: {
                        if (parsingName) {
                            nameEnd = pos++;
                            parsingName = false;
                            valueStart = pos;
                            break;
                        }
                        ++pos;
                        break;
                    }
                    case 38: {
                        if (parsingName) {
                            nameEnd = pos;
                        } else {
                            valueEnd = pos;
                        }
                        parameterComplete = true;
                        ++pos;
                        break;
                    }
                    case 37: 
                    case 43: {
                        if (parsingName) {
                            decodeName = true;
                        } else {
                            decodeValue = true;
                        }
                        ++pos;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            } while (!parameterComplete && pos < end);
            if (pos == end) {
                if (nameEnd == -1) {
                    nameEnd = pos;
                } else if (valueStart > -1 && valueEnd == -1) {
                    valueEnd = pos;
                }
            }
            if (log.isDebugEnabled() && valueStart == -1) {
                log.debug(sm.getString("parameters.noequal", nameStart, nameEnd, new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_BODY_CHARSET)));
            }
            if (nameEnd <= nameStart) {
                if (valueStart == -1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(sm.getString("parameters.emptyChunk"));
                    continue;
                }
                String extract = valueEnd > nameStart ? new String(bytes, nameStart, valueEnd - nameStart, DEFAULT_BODY_CHARSET) : "";
                message = sm.getString("parameters.invalidChunk", nameStart, valueEnd, extract);
                throw new InvalidParameterException(message);
            }
            this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
            if (valueStart >= 0) {
                this.tmpValue.setBytes(bytes, valueStart, valueEnd - valueStart);
            } else {
                this.tmpValue.setBytes(bytes, 0, 0);
            }
            if (log.isDebugEnabled()) {
                try {
                    this.origName.append(bytes, nameStart, nameEnd - nameStart);
                    if (valueStart >= 0) {
                        this.origValue.append(bytes, valueStart, valueEnd - valueStart);
                    } else {
                        this.origValue.append(bytes, 0, 0);
                    }
                }
                catch (IOException ioe) {
                    log.error(sm.getString("parameters.copyFail"), ioe);
                }
            }
            try {
                String value;
                if (decodeName) {
                    this.urlDecode(this.tmpName);
                }
                this.tmpName.setCharset(charset);
                String name = this.tmpName.toString(CodingErrorAction.REPORT, CodingErrorAction.REPORT);
                if (valueStart >= 0) {
                    if (decodeValue) {
                        this.urlDecode(this.tmpValue);
                    }
                    this.tmpValue.setCharset(charset);
                    value = this.tmpValue.toString(CodingErrorAction.REPORT, CodingErrorAction.REPORT);
                } else {
                    value = "";
                }
                this.addParameter(name, value);
            }
            catch (IOException e) {
                message = log.isDebugEnabled() ? sm.getString("parameters.decodeFail.debug", this.origName.toString(), this.origValue.toString()) : sm.getString("parameters.decodeFail.info", this.tmpName.toString(), this.tmpValue.toString());
                throw new InvalidParameterException(message, e);
            }
            finally {
                this.tmpName.recycle();
                this.tmpValue.recycle();
                if (!log.isDebugEnabled()) continue;
                this.origName.recycle();
                this.origValue.recycle();
            }
        }
    }

    private void urlDecode(ByteChunk bc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc, true);
    }

    public void processParameters(MessageBytes data, Charset charset) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() != 2) {
            data.toBytes();
        }
        ByteChunk bc = data.getByteChunk();
        this.processParameters(bc.getBytes(), bc.getStart(), bc.getLength(), charset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ArrayList<String>> e : this.paramHashValues.entrySet()) {
            sb.append(e.getKey()).append('=');
            StringUtils.join((Iterable<String>)e.getValue(), ',', sb);
            sb.append('\n');
        }
        return sb.toString();
    }
}

