/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterChain
implements FilterChain {
    private static final ThreadLocal<ServletRequest> lastServicedRequest = new ThreadLocal();
    private static final ThreadLocal<ServletResponse> lastServicedResponse = new ThreadLocal();
    public static final int INCREMENT = 10;
    private ApplicationFilterConfig[] filters = new ApplicationFilterConfig[0];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private boolean servletSupportsAsync = false;
    private boolean dispatcherWrapsSameObject = false;
    private static final StringManager sm = StringManager.getManager(ApplicationFilterChain.class);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            ApplicationFilterConfig filterConfig = this.filters[this.pos++];
            try {
                Filter filter = filterConfig.getFilter();
                if (request.isAsyncSupported() && !filterConfig.getFilterDef().getAsyncSupportedBoolean()) {
                    request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", Boolean.FALSE);
                }
                filter.doFilter(request, response, this);
            }
            catch (ServletException | IOException | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(request);
                lastServicedResponse.set(response);
            }
            if (request.isAsyncSupported() && !this.servletSupportsAsync) {
                request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", Boolean.FALSE);
            }
            this.servlet.service(request, response);
        }
        catch (ServletException | IOException | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            ExceptionUtils.handleThrowable(e);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
        finally {
            if (this.dispatcherWrapsSameObject) {
                lastServicedRequest.set(null);
                lastServicedResponse.set(null);
            }
        }
    }

    public static ServletRequest getLastServicedRequest() {
        return lastServicedRequest.get();
    }

    public static ServletResponse getLastServicedResponse() {
        return lastServicedResponse.get();
    }

    void addFilter(ApplicationFilterConfig filterConfig) {
        for (int i = 0; i < this.n; ++i) {
            if (this.filters[i] != filterConfig) continue;
            return;
        }
        if (this.n == this.filters.length) {
            this.filters = Arrays.copyOf(this.filters, this.n + 10);
        }
        this.filters[this.n++] = filterConfig;
    }

    void release() {
        for (int i = 0; i < this.n; ++i) {
            this.filters[i] = null;
        }
        this.n = 0;
        this.pos = 0;
        this.servlet = null;
        this.servletSupportsAsync = false;
        this.dispatcherWrapsSameObject = false;
    }

    void reuse() {
        this.pos = 0;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setServletSupportsAsync(boolean servletSupportsAsync) {
        this.servletSupportsAsync = servletSupportsAsync;
    }

    void setDispatcherWrapsSameObject(boolean dispatcherWrapsSameObject) {
        this.dispatcherWrapsSameObject = dispatcherWrapsSameObject;
    }

    public void findNonAsyncFilters(Set<String> result) {
        for (int i = 0; i < this.n; ++i) {
            ApplicationFilterConfig filter = this.filters[i];
            if (filter.getFilterDef().getAsyncSupportedBoolean()) continue;
            result.add(filter.getFilterClass());
        }
    }
}

