/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.Group;
import org.apache.tomcat.util.net.openssl.ciphers.SignatureScheme;
import org.apache.tomcat.util.res.StringManager;

public class TLSClientHelloExtractor {
    private static final Log log = LogFactory.getLog(TLSClientHelloExtractor.class);
    private static final StringManager sm = StringManager.getManager(TLSClientHelloExtractor.class);
    private final ExtractorResult result;
    private final List<Cipher> clientRequestedCiphers;
    private final List<String> clientRequestedCipherNames;
    private final String sniValue;
    private final List<String> clientRequestedApplicationProtocols;
    private final List<String> clientRequestedProtocols;
    private final List<Group> clientSupportedGroups;
    private final List<SignatureScheme> clientSignatureSchemes;
    private static final int TLS_RECORD_HEADER_LEN = 5;
    private static final int TLS_EXTENSION_SERVER_NAME = 0;
    private static final int TLS_EXTENSION_SUPPORTED_GROUPS = 10;
    private static final int TLS_EXTENSION_SIGNATURE_ALGORITHMS = 13;
    private static final int TLS_EXTENSION_ALPN = 16;
    private static final int TLS_EXTENSION_SUPPORTED_VERSION = 43;
    public static byte[] USE_TLS_RESPONSE = "HTTP/1.1 400 \r\nContent-Type: text/plain;charset=UTF-8\r\nConnection: close\r\n\r\nBad Request\r\nThis combination of host and port requires TLS.\r\n".getBytes(StandardCharsets.UTF_8);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TLSClientHelloExtractor(ByteBuffer netInBuffer) throws IOException {
        String sniValue;
        ArrayList<SignatureScheme> clientSignatureSchemes;
        ArrayList<Group> clientSupportedGroups;
        ArrayList<String> clientRequestedProtocols;
        ArrayList<String> clientRequestedApplicationProtocols;
        ArrayList<String> clientRequestedCipherNames;
        ArrayList<Cipher> clientRequestedCiphers;
        ExtractorResult result;
        int limit;
        int pos;
        block32: {
            block31: {
                pos = netInBuffer.position();
                limit = netInBuffer.limit();
                result = ExtractorResult.NOT_PRESENT;
                clientRequestedCiphers = new ArrayList<Cipher>();
                clientRequestedCipherNames = new ArrayList<String>();
                clientRequestedApplicationProtocols = new ArrayList<String>();
                clientRequestedProtocols = new ArrayList<String>();
                clientSupportedGroups = new ArrayList<Group>();
                clientSignatureSchemes = new ArrayList<SignatureScheme>();
                sniValue = null;
                try {
                    netInBuffer.flip();
                    if (!TLSClientHelloExtractor.isAvailable(netInBuffer, 5)) {
                        result = TLSClientHelloExtractor.handleIncompleteRead(netInBuffer);
                        return;
                    }
                    if (!TLSClientHelloExtractor.isTLSHandshake(netInBuffer)) {
                        if (!TLSClientHelloExtractor.isHttp(netInBuffer)) return;
                        result = ExtractorResult.NON_SECURE;
                        return;
                    }
                    if (!TLSClientHelloExtractor.isAllRecordAvailable(netInBuffer)) {
                        result = TLSClientHelloExtractor.handleIncompleteRead(netInBuffer);
                        return;
                    }
                    if (!TLSClientHelloExtractor.isClientHello(netInBuffer)) {
                        return;
                    }
                    if (!TLSClientHelloExtractor.isAllClientHelloAvailable(netInBuffer)) {
                        log.warn(sm.getString("sniExtractor.clientHelloTooBig"));
                        return;
                    }
                    String legacyVersion = TLSClientHelloExtractor.readProtocol(netInBuffer);
                    TLSClientHelloExtractor.skipBytes(netInBuffer, 32);
                    TLSClientHelloExtractor.skipBytes(netInBuffer, netInBuffer.get() & 0xFF);
                    int cipherCount = netInBuffer.getChar() / 2;
                    for (int i = 0; i < cipherCount; ++i) {
                        char cipherId = netInBuffer.getChar();
                        Cipher c = Cipher.valueOf((int)cipherId);
                        if (c == null) {
                            clientRequestedCipherNames.add("Unknown(0x" + HexUtils.toHexString(cipherId) + ")");
                            continue;
                        }
                        clientRequestedCiphers.add(c);
                        clientRequestedCipherNames.add(c.name());
                    }
                    TLSClientHelloExtractor.skipBytes(netInBuffer, netInBuffer.get() & 0xFF);
                    if (!netInBuffer.hasRemaining()) {
                        this.result = result;
                        this.clientRequestedCiphers = clientRequestedCiphers;
                        this.clientRequestedCipherNames = clientRequestedCipherNames;
                        this.clientRequestedApplicationProtocols = clientRequestedApplicationProtocols;
                        this.sniValue = sniValue;
                        this.clientRequestedProtocols = clientRequestedProtocols;
                        this.clientSupportedGroups = clientSupportedGroups;
                        this.clientSignatureSchemes = clientSignatureSchemes;
                        break block31;
                    }
                    TLSClientHelloExtractor.skipBytes(netInBuffer, 2);
                    block19: while (netInBuffer.hasRemaining() && (sniValue == null || clientRequestedApplicationProtocols.isEmpty() || clientRequestedProtocols.isEmpty())) {
                        char extensionType = netInBuffer.getChar();
                        char extensionDataSize = netInBuffer.getChar();
                        switch (extensionType) {
                            case '\u0000': {
                                sniValue = TLSClientHelloExtractor.readSniExtension(netInBuffer);
                                continue block19;
                            }
                            case '\n': {
                                TLSClientHelloExtractor.readSupportedGroups(netInBuffer, clientSupportedGroups);
                                continue block19;
                            }
                            case '\r': {
                                TLSClientHelloExtractor.readSignatureSchemes(netInBuffer, clientSignatureSchemes);
                                continue block19;
                            }
                            case '\u0010': {
                                TLSClientHelloExtractor.readAlpnExtension(netInBuffer, clientRequestedApplicationProtocols);
                                continue block19;
                            }
                            case '+': {
                                TLSClientHelloExtractor.readSupportedVersions(netInBuffer, clientRequestedProtocols);
                                continue block19;
                            }
                        }
                        TLSClientHelloExtractor.skipBytes(netInBuffer, extensionDataSize);
                    }
                    if (clientRequestedProtocols.isEmpty()) {
                        clientRequestedProtocols.add(legacyVersion);
                    }
                    this.result = result = ExtractorResult.COMPLETE;
                    break block32;
                }
                catch (IllegalArgumentException | BufferUnderflowException e) {
                    throw new IOException(sm.getString("sniExtractor.clientHelloInvalid"), e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("TLS Client Hello: " + String.valueOf(clientRequestedCiphers) + " Names " + String.valueOf(clientRequestedCipherNames) + " Protocols " + String.valueOf(clientRequestedApplicationProtocols) + " sniValue " + sniValue + " clientRequestedProtocols " + String.valueOf(clientRequestedProtocols) + " clientSupportedGroups " + String.valueOf(clientSupportedGroups) + " clientSignatureSchemes " + String.valueOf(clientSignatureSchemes));
            }
            netInBuffer.limit(limit);
            netInBuffer.position(pos);
            return;
        }
        this.clientRequestedCiphers = clientRequestedCiphers;
        this.clientRequestedCipherNames = clientRequestedCipherNames;
        this.clientRequestedApplicationProtocols = clientRequestedApplicationProtocols;
        this.sniValue = sniValue;
        this.clientRequestedProtocols = clientRequestedProtocols;
        this.clientSupportedGroups = clientSupportedGroups;
        this.clientSignatureSchemes = clientSignatureSchemes;
        if (log.isTraceEnabled()) {
            log.trace("TLS Client Hello: " + String.valueOf(clientRequestedCiphers) + " Names " + String.valueOf(clientRequestedCipherNames) + " Protocols " + String.valueOf(clientRequestedApplicationProtocols) + " sniValue " + sniValue + " clientRequestedProtocols " + String.valueOf(clientRequestedProtocols) + " clientSupportedGroups " + String.valueOf(clientSupportedGroups) + " clientSignatureSchemes " + String.valueOf(clientSignatureSchemes));
        }
        netInBuffer.limit(limit);
        netInBuffer.position(pos);
        return;
        finally {
            this.result = result;
            this.clientRequestedCiphers = clientRequestedCiphers;
            this.clientRequestedCipherNames = clientRequestedCipherNames;
            this.clientRequestedApplicationProtocols = clientRequestedApplicationProtocols;
            this.sniValue = sniValue;
            this.clientRequestedProtocols = clientRequestedProtocols;
            this.clientSupportedGroups = clientSupportedGroups;
            this.clientSignatureSchemes = clientSignatureSchemes;
            if (log.isTraceEnabled()) {
                log.trace("TLS Client Hello: " + String.valueOf(clientRequestedCiphers) + " Names " + String.valueOf(clientRequestedCipherNames) + " Protocols " + String.valueOf(clientRequestedApplicationProtocols) + " sniValue " + sniValue + " clientRequestedProtocols " + String.valueOf(clientRequestedProtocols) + " clientSupportedGroups " + String.valueOf(clientSupportedGroups) + " clientSignatureSchemes " + String.valueOf(clientSignatureSchemes));
            }
            netInBuffer.limit(limit);
            netInBuffer.position(pos);
        }
    }

    public ExtractorResult getResult() {
        return this.result;
    }

    public String getSNIValue() {
        if (this.result == ExtractorResult.COMPLETE) {
            return this.sniValue;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<Cipher> getClientRequestedCiphers() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedCiphers;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedCipherNames() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedCipherNames;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedApplicationProtocols() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedApplicationProtocols;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<String> getClientRequestedProtocols() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedProtocols;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<Group> getClientSupportedGroups() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientSupportedGroups;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    public List<SignatureScheme> getClientSignatureSchemes() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientSignatureSchemes;
        }
        throw new IllegalStateException(sm.getString("sniExtractor.tooEarly"));
    }

    private static ExtractorResult handleIncompleteRead(ByteBuffer bb) {
        if (bb.limit() == bb.capacity()) {
            return ExtractorResult.UNDERFLOW;
        }
        return ExtractorResult.NEED_READ;
    }

    private static boolean isAvailable(ByteBuffer bb, int size) {
        if (bb.remaining() < size) {
            bb.position(bb.limit());
            return false;
        }
        return true;
    }

    private static boolean isTLSHandshake(ByteBuffer bb) {
        if (bb.get() != 22) {
            return false;
        }
        byte b2 = bb.get();
        byte b3 = bb.get();
        return b2 >= 3 && (b2 != 3 || b3 != 0);
    }

    private static boolean isHttp(ByteBuffer bb) {
        byte chr;
        bb.position(0);
        do {
            if (bb.hasRemaining()) continue;
            return false;
        } while ((chr = bb.get()) == 13 || chr == 10);
        do {
            if (HttpParser.isToken(chr) && bb.hasRemaining()) continue;
            return false;
        } while ((chr = bb.get()) != 32 && chr != 9);
        while (chr == 32 || chr == 9) {
            if (!bb.hasRemaining()) {
                return false;
            }
            chr = bb.get();
        }
        while (chr != 32 && chr != 9) {
            if (HttpParser.isNotRequestTarget(chr) || !bb.hasRemaining()) {
                return false;
            }
            chr = bb.get();
        }
        while (chr == 32 || chr == 9) {
            if (!bb.hasRemaining()) {
                return false;
            }
            chr = bb.get();
        }
        do {
            if (HttpParser.isHttpProtocol(chr) && bb.hasRemaining()) continue;
            return false;
        } while ((chr = bb.get()) != 13 && chr != 10);
        return true;
    }

    private static boolean isAllRecordAvailable(ByteBuffer bb) {
        char size = bb.getChar();
        return TLSClientHelloExtractor.isAvailable(bb, size);
    }

    private static boolean isClientHello(ByteBuffer bb) {
        return bb.get() == 1;
    }

    private static boolean isAllClientHelloAvailable(ByteBuffer bb) {
        int size = ((bb.get() & 0xFF) << 16) + ((bb.get() & 0xFF) << 8) + (bb.get() & 0xFF);
        return TLSClientHelloExtractor.isAvailable(bb, size);
    }

    private static void skipBytes(ByteBuffer bb, int size) {
        bb.position(bb.position() + size);
    }

    private static String readProtocol(ByteBuffer bb) {
        char protocol = bb.getChar();
        return switch (protocol) {
            case '\u0300' -> "SSLv3";
            case '\u0301' -> "TLSv1.0";
            case '\u0302' -> "TLSv1.1";
            case '\u0303' -> "TLSv1.2";
            case '\u0304' -> "TLSv1.3";
            default -> "Unknown(0x" + HexUtils.toHexString(protocol) + ")";
        };
    }

    private static String readSniExtension(ByteBuffer bb) {
        TLSClientHelloExtractor.skipBytes(bb, 3);
        char serverNameSize = bb.getChar();
        byte[] serverNameBytes = new byte[serverNameSize];
        bb.get(serverNameBytes);
        return new String(serverNameBytes, StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH);
    }

    private static void readAlpnExtension(ByteBuffer bb, List<String> protocolNames) {
        char toRead = bb.getChar();
        byte[] inputBuffer = new byte[255];
        while (toRead > '\u0000') {
            int len = bb.get() & 0xFF;
            bb.get(inputBuffer, 0, len);
            protocolNames.add(new String(inputBuffer, 0, len, StandardCharsets.UTF_8));
            toRead = (char)(toRead - '\u0001');
            toRead = (char)(toRead - (char)len);
        }
    }

    private static void readSupportedVersions(ByteBuffer bb, List<String> protocolNames) {
        int count = (bb.get() & 0xFF) / 2;
        for (int i = 0; i < count; ++i) {
            protocolNames.add(TLSClientHelloExtractor.readProtocol(bb));
        }
    }

    private static void readSupportedGroups(ByteBuffer bb, List<Group> groups) {
        int toRead = bb.getChar() / 2;
        for (int i = 0; i < toRead; ++i) {
            char id = bb.getChar();
            Group group = Group.valueOf((int)id);
            if (group == null) continue;
            groups.add(group);
        }
    }

    private static void readSignatureSchemes(ByteBuffer bb, List<SignatureScheme> signatureSchemes) {
        int toRead = bb.getChar() / 2;
        for (int i = 0; i < toRead; ++i) {
            char id = bb.getChar();
            SignatureScheme signatureScheme = SignatureScheme.valueOf((int)id);
            if (signatureScheme == null) continue;
            signatureSchemes.add(signatureScheme);
        }
    }

    public static enum ExtractorResult {
        COMPLETE,
        NOT_PRESENT,
        UNDERFLOW,
        NEED_READ,
        NON_SECURE;

    }
}

