/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import jakarta.servlet.jsp.el.ImplicitObjectELResolver;
import jakarta.servlet.jsp.el.ScopedAttributeELResolver;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.JspRuntimeLibrary;

public class JasperELResolver
extends CompositeELResolver {
    private static final int STANDARD_RESOLVERS_COUNT = 9;
    private AtomicInteger resolversSize = new AtomicInteger(0);
    private volatile ELResolver[] resolvers;
    private final int appResolversSize;

    public JasperELResolver(List<ELResolver> appResolvers, ELResolver streamResolver) {
        this.appResolversSize = appResolvers.size();
        this.resolvers = new ELResolver[this.appResolversSize + 9];
        this.add(new ImplicitObjectELResolver());
        for (ELResolver appResolver : appResolvers) {
            this.add(appResolver);
        }
        this.add(streamResolver);
        this.add((ELResolver)new StaticFieldELResolver());
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new ArrayELResolver());
        if (JspRuntimeLibrary.GRAAL) {
            this.add(new GraalBeanELResolver());
        }
        this.add((ELResolver)new BeanELResolver());
        this.add(new ScopedAttributeELResolver());
    }

    public synchronized void add(ELResolver elResolver) {
        super.add(elResolver);
        int size = this.resolversSize.get();
        if (this.resolvers.length > size) {
            this.resolvers[size] = elResolver;
        } else {
            ELResolver[] nr = new ELResolver[size + 1];
            System.arraycopy(this.resolvers, 0, nr, 0, size);
            nr[size] = elResolver;
            this.resolvers = nr;
        }
        this.resolversSize.incrementAndGet();
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int start;
        int i;
        context.setPropertyResolved(false);
        Object result = null;
        if (base == null) {
            int index = 1 + this.appResolversSize;
            for (i = 0; i < index; ++i) {
                result = this.resolvers[i].getValue(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return result;
            }
            start = index + 7;
            if (JspRuntimeLibrary.GRAAL) {
                ++start;
            }
        } else {
            start = 1;
        }
        int size = this.resolversSize.get();
        for (i = start; i < size; ++i) {
            result = this.resolvers[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        String targetMethod = JasperELResolver.coerceToString(method);
        if (targetMethod.length() == 0) {
            throw new ELException((Throwable)new NoSuchMethodException());
        }
        context.setPropertyResolved(false);
        Object result = null;
        int index = 1 + this.appResolversSize + 2;
        for (int i = 1; i < index; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        int size = this.resolversSize.get();
        for (int i = index += 4; i < size; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    private static final String coerceToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return obj.toString();
    }

    private static class GraalBeanELResolver
    extends ELResolver {
        private GraalBeanELResolver() {
        }

        public Object getValue(ELContext context, Object base, Object property) {
            Object value = null;
            Method method = GraalBeanELResolver.getReadMethod(base.getClass(), property.toString());
            if (method != null) {
                context.setPropertyResolved(base, property);
                try {
                    value = method.invoke(base, (Object[])null);
                }
                catch (Exception ex) {
                    Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
                    ExceptionUtils.handleThrowable(thr);
                }
            }
            return value;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            Method method = GraalBeanELResolver.getWriteMethod(base.getClass(), property.toString());
            if (method != null) {
                context.setPropertyResolved(base, property);
                try {
                    method.invoke(base, value);
                }
                catch (Exception ex) {
                    Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
                    ExceptionUtils.handleThrowable(thr);
                }
            }
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            String prop;
            Class<?> beanClass = base.getClass();
            return GraalBeanELResolver.getReadMethod(beanClass, prop = property.toString()) != null && GraalBeanELResolver.getWriteMethod(beanClass, prop) != null;
        }

        public static Method getReadMethod(Class<?> beanClass, String prop) {
            Method[] methods;
            Method result = null;
            String setter = "get" + GraalBeanELResolver.capitalize(prop);
            for (Method method : methods = beanClass.getMethods()) {
                if (!setter.equals(method.getName())) continue;
                return method;
            }
            return result;
        }

        public static Method getWriteMethod(Class<?> beanClass, String prop) {
            Method[] methods;
            Method result = null;
            String setter = "set" + GraalBeanELResolver.capitalize(prop);
            for (Method method : methods = beanClass.getMethods()) {
                if (!setter.equals(method.getName())) continue;
                return method;
            }
            return result;
        }

        public static String capitalize(String name) {
            if (name == null || name.length() == 0) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return null;
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return null;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return null;
        }
    }
}

