/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerHelper {
    private TinkerHelper() {
    }

    public static Map<String, List<VertexProperty>> getProperties(TinkerVertex vertex) {
        return null == vertex.properties ? Collections.emptyMap() : vertex.properties;
    }

    public static boolean inComputerMode(AbstractTinkerGraph graph) {
        return null != graph.graphComputerView;
    }

    public static TinkerGraphComputerView createGraphComputerView(AbstractTinkerGraph graph, GraphFilter graphFilter, Set<VertexComputeKey> computeKeys) {
        graph.graphComputerView = new TinkerGraphComputerView(graph, graphFilter, computeKeys);
        return graph.graphComputerView;
    }

    public static TinkerGraphComputerView getGraphComputerView(AbstractTinkerGraph graph) {
        return graph.graphComputerView;
    }

    public static void dropGraphComputerView(AbstractTinkerGraph graph) {
        graph.graphComputerView = null;
    }

    public static Iterator<TinkerEdge> getEdges(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        ArrayList edges = new ArrayList();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdges.values().forEach(edges::addAll);
            } else if (edgeLabels.length == 1) {
                edges.addAll(vertex.outEdges.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdges::get).filter(Objects::nonNull).forEach(edges::addAll);
            }
        }
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdges.values().forEach(edges::addAll);
            } else if (edgeLabels.length == 1) {
                edges.addAll(vertex.inEdges.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdges::get).filter(Objects::nonNull).forEach(edges::addAll);
            }
        }
        return edges.iterator();
    }

    public static Iterator<TinkerEdge> getEdgesTx(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        ArrayList outEdgeIds = new ArrayList();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdgesId != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdgesId.values().forEach(outEdgeIds::addAll);
            } else if (edgeLabels.length == 1) {
                outEdgeIds.addAll(vertex.outEdgesId.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdgesId::get).filter(Objects::nonNull).forEach(outEdgeIds::addAll);
            }
        }
        ArrayList inEdgeIds = new ArrayList();
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdgesId != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdgesId.values().forEach(inEdgeIds::addAll);
            } else if (edgeLabels.length == 1) {
                inEdgeIds.addAll(vertex.inEdgesId.getOrDefault(edgeLabels[0], Collections.emptySet()));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdgesId::get).filter(Objects::nonNull).forEach(inEdgeIds::addAll);
            }
        }
        return outEdgeIds.size() == 0 && inEdgeIds.size() == 0 ? Collections.emptyIterator() : Stream.concat(outEdgeIds.stream(), inEdgeIds.stream()).map(id -> ((AbstractTinkerGraph)vertex.graph()).edge(id)).filter(v -> v != null).map(v -> (TinkerEdge)v).iterator();
    }

    public static Iterator<TinkerVertex> getVertices(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        ArrayList vertices = new ArrayList();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdges.values().forEach(set -> set.forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex)));
            } else if (edgeLabels.length == 1) {
                vertex.outEdges.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdges::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> vertices.add(((TinkerEdge)edge).inVertex));
            }
        }
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdges != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdges.values().forEach(set -> set.forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex)));
            } else if (edgeLabels.length == 1) {
                vertex.inEdges.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdges::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> vertices.add(((TinkerEdge)edge).outVertex));
            }
        }
        return vertices.iterator();
    }

    public static Iterator<TinkerVertex> getVerticesTx(TinkerVertex vertex, Direction direction, String ... edgeLabels) {
        HashSet inEdgesIds = new HashSet();
        if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && vertex.outEdgesId != null) {
            if (edgeLabels.length == 0) {
                vertex.outEdgesId.values().forEach(set -> set.forEach(edge -> inEdgesIds.add(edge)));
            } else if (edgeLabels.length == 1) {
                vertex.outEdgesId.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> inEdgesIds.add(edge));
            } else {
                Stream.of(edgeLabels).map(vertex.outEdgesId::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> inEdgesIds.add(edge));
            }
        }
        HashSet outEdgesIds = new HashSet();
        if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && vertex.inEdgesId != null) {
            if (edgeLabels.length == 0) {
                vertex.inEdgesId.values().forEach(set -> set.forEach(edge -> outEdgesIds.add(edge)));
            } else if (edgeLabels.length == 1) {
                vertex.inEdgesId.getOrDefault(edgeLabels[0], Collections.emptySet()).forEach(edge -> outEdgesIds.add(edge));
            } else {
                Stream.of(edgeLabels).map(vertex.inEdgesId::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(edge -> outEdgesIds.add(edge));
            }
        }
        ArrayList vertices = new ArrayList();
        if (inEdgesIds.size() != 0) {
            vertex.graph().edges(inEdgesIds.toArray()).forEachRemaining(edge -> vertices.add(edge.inVertex()));
        }
        if (outEdgesIds.size() != 0) {
            vertex.graph().edges(outEdgesIds.toArray()).forEachRemaining(edge -> vertices.add(edge.outVertex()));
        }
        return vertices.size() == 0 ? Collections.emptyIterator() : vertices.stream().map(v -> (TinkerVertex)v).iterator();
    }

    public static <E extends Element> Iterator<Property> search(AbstractTinkerGraph graph, String regex, Optional<Class<E>> type) {
        Iterator it;
        Supplier<Iterator> vertices = () -> IteratorUtils.cast(graph.vertices(new Object[0]));
        Supplier<Iterator> edges = () -> IteratorUtils.cast(graph.edges(new Object[0]));
        Supplier<Iterator> vertexProperties = () -> IteratorUtils.flatMap((Iterator)((Iterator)vertices.get()), v -> IteratorUtils.cast((Iterator)v.properties(new String[0])));
        if (!type.isPresent()) {
            it = IteratorUtils.concat((Iterator[])new Iterator[]{vertices.get(), edges.get(), vertexProperties.get()});
        } else {
            switch (type.get().getSimpleName()) {
                case "Edge": {
                    it = edges.get();
                    break;
                }
                case "Vertex": {
                    it = vertices.get();
                    break;
                }
                case "VertexProperty": {
                    it = vertexProperties.get();
                    break;
                }
                default: {
                    it = IteratorUtils.concat((Iterator[])new Iterator[]{vertices.get(), edges.get(), vertexProperties.get()});
                }
            }
        }
        Pattern pattern = Pattern.compile(regex);
        it = IteratorUtils.flatMap((Iterator)it, e -> IteratorUtils.cast((Iterator)e.properties(new String[0])));
        it = IteratorUtils.filter((Iterator)it, p -> pattern.matcher(p.value().toString()).matches());
        return it;
    }

    public static Iterator<Property> search(TinkerGraph graph, String regex) {
        return TinkerHelper.search(graph, regex, Optional.empty());
    }
}

