/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public final class TinkerIoRegistry
extends AbstractIoRegistry {
    private static final TinkerIoRegistry INSTANCE = new TinkerIoRegistry();

    private TinkerIoRegistry() {
        this.register(GryoIo.class, TinkerGraph.class, (Object)new TinkerGraphSerializer());
    }

    public static TinkerIoRegistry getInstance() {
        return INSTANCE;
    }

    static final class TinkerGraphSerializer
    extends Serializer<TinkerGraph> {
        TinkerGraphSerializer() {
        }

        public void write(Kryo kryo, Output output, TinkerGraph graph) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                GryoWriter.build().mapper(() -> kryo).create().writeGraph((OutputStream)stream, (Graph)graph);
                byte[] bytes = stream.toByteArray();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        }

        public TinkerGraph read(Kryo kryo, Input input, Class<TinkerGraph> tinkerGraphClass) {
            TinkerGraph graph = TinkerGraph.open();
            int len = input.readInt();
            byte[] bytes = input.readBytes(len);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                GryoReader.build().mapper(() -> kryo).create().readGraph((InputStream)stream, (Graph)graph);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
            return graph;
        }
    }
}

