/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerMessageBoard;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;

public final class TinkerMessenger<M>
implements Messenger<M> {
    private final Vertex vertex;
    private final TinkerMessageBoard<M> messageBoard;
    private final MessageCombiner<M> combiner;

    public TinkerMessenger(Vertex vertex, TinkerMessageBoard<M> messageBoard, Optional<MessageCombiner<M>> combiner) {
        this.vertex = vertex;
        this.messageBoard = messageBoard;
        this.combiner = combiner.isPresent() ? combiner.get() : null;
    }

    public Iterator<M> receiveMessages() {
        MultiIterator multiIterator = new MultiIterator();
        for (MessageScope messageScope : this.messageBoard.previousMessageScopes) {
            if (messageScope instanceof MessageScope.Local) {
                MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
                Object incidentTraversal = TinkerMessenger.setVertexStart((Traversal.Admin<Vertex, Edge>)((Traversal)localMessageScope.getIncidentTraversal().get()).asAdmin(), this.vertex);
                Direction direction = TinkerMessenger.getDirection(incidentTraversal);
                Edge[] edge = new Edge[1];
                multiIterator.addIterator(StreamSupport.stream(Spliterators.spliteratorUnknownSize(VertexProgramHelper.reverse((Traversal.Admin)incidentTraversal.asAdmin()), 1088), false).map(e -> {
                    edgeArray[0] = e;
                    return this.messageBoard.receiveMessages.get(edgeArray[0].vertices(direction).next());
                }).filter(q -> null != q).flatMap(Collection::stream).map(message -> localMessageScope.getEdgeFunction().apply(message, edge[0])).iterator());
                continue;
            }
            multiIterator.addIterator(Stream.of(this.vertex).map(this.messageBoard.receiveMessages::get).filter(q -> null != q).flatMap(Collection::stream).iterator());
        }
        return multiIterator;
    }

    public void sendMessage(MessageScope messageScope, M message) {
        this.messageBoard.currentMessageScopes.add(messageScope);
        if (messageScope instanceof MessageScope.Local) {
            this.addMessage(this.vertex, message);
        } else {
            ((MessageScope.Global)messageScope).vertices().forEach(v -> this.addMessage((Vertex)v, message));
        }
    }

    private void addMessage(Vertex vertex, M message) {
        this.messageBoard.sendMessages.compute(vertex, (v, queue) -> {
            if (null == queue) {
                queue = new ConcurrentLinkedQueue<Object>();
            }
            queue.add(null != this.combiner && !queue.isEmpty() ? this.combiner.combine(queue.remove(), message) : message);
            return queue;
        });
    }

    private static <T extends Traversal.Admin<Vertex, Edge>> T setVertexStart(Traversal.Admin<Vertex, Edge> incidentTraversal, Vertex vertex) {
        incidentTraversal.addStep(0, (Step)new StartStep(incidentTraversal, (Object)vertex));
        return (T)incidentTraversal;
    }

    private static Direction getDirection(Traversal.Admin<Vertex, Edge> incidentTraversal) {
        VertexStep step = (VertexStep)TraversalHelper.getLastStepOfAssignableClass(VertexStep.class, incidentTraversal).get();
        return step.getDirection();
    }
}

