/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql;

import java.util.Arrays;
import java.util.List;

class Prefixes {
    static final String BASE_URI = "http://tinkerpop.apache.org/traversal/";
    private static final List<String> PREFIXES = Arrays.asList("edge", "property", "value");
    private static final String PREFIX_DEFINITIONS;

    Prefixes() {
    }

    static String getURI(String prefix) {
        return BASE_URI + prefix + "#";
    }

    static String getURIValue(String uri) {
        return uri.substring(uri.indexOf("#") + 1);
    }

    static String getPrefix(String uri) {
        String tmp = uri.substring(0, uri.indexOf("#"));
        return tmp.substring(tmp.lastIndexOf("/") + 1);
    }

    static String prepend(String script) {
        return PREFIX_DEFINITIONS + script;
    }

    static StringBuilder prepend(StringBuilder scriptBuilder) {
        return scriptBuilder.insert(0, PREFIX_DEFINITIONS);
    }

    static {
        StringBuilder builder = new StringBuilder();
        for (String prefix : PREFIXES) {
            builder.append("PREFIX ").append(prefix, 0, 1).append(": <").append(Prefixes.getURI(prefix)).append(">").append(System.lineSeparator());
        }
        PREFIX_DEFINITIONS = builder.toString();
    }
}

