/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.sparql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.sparql.Prefixes;
import org.apache.tinkerpop.gremlin.sparql.TraversalBuilder;
import org.apache.tinkerpop.gremlin.sparql.WhereTraversalBuilder;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class SparqlToGremlinCompiler {
    private GraphTraversal<Vertex, ?> traversal;
    private List<Traversal> traversalList = new ArrayList<Traversal>();
    List<Traversal> optionalTraversals = new ArrayList<Traversal>();
    List<String> optionalVariable = new ArrayList<String>();
    boolean optionalFlag = false;

    private SparqlToGremlinCompiler(GraphTraversal<Vertex, ?> traversal) {
        this.traversal = traversal;
    }

    private SparqlToGremlinCompiler(GraphTraversalSource g) {
        this(g.V(new Object[0]));
    }

    public static GraphTraversal<Vertex, ?> compile(Graph graph, String sparqlQuery) {
        return SparqlToGremlinCompiler.compile(graph.traversal(), sparqlQuery);
    }

    public static GraphTraversal<Vertex, ?> compile(GraphTraversalSource g, String sparqlQuery) {
        return SparqlToGremlinCompiler.compile(g, QueryFactory.create((String)Prefixes.prepend(sparqlQuery), (Syntax)Syntax.syntaxSPARQL));
    }

    private GraphTraversal<Vertex, ?> compile(Query query) {
        Op op = Algebra.compile((Query)query);
        OpWalker.walk((Op)op, (OpVisitor)new GremlinOpVisitor());
        int traversalIndex = 0;
        int numberOfTraversal = this.traversalList.size();
        int numberOfOptionalTraversal = this.optionalTraversals.size();
        Traversal[] arrayOfAllTraversals = numberOfOptionalTraversal > 0 ? new Traversal[numberOfTraversal - numberOfOptionalTraversal + 1] : new Traversal[numberOfTraversal - numberOfOptionalTraversal];
        Traversal[] arrayOfOptionalTraversals = new Traversal[numberOfOptionalTraversal];
        for (Traversal tempTrav : this.traversalList) {
            arrayOfAllTraversals[traversalIndex++] = tempTrav;
        }
        traversalIndex = 0;
        for (Traversal tempTrav : this.optionalTraversals) {
            arrayOfOptionalTraversals[traversalIndex++] = tempTrav;
        }
        Map<String, Order> orderingIndex = SparqlToGremlinCompiler.createOrderIndexFromQuery(query);
        if (this.traversalList.size() > 0) {
            this.traversal = this.traversal.match(arrayOfAllTraversals);
        }
        if (this.optionalTraversals.size() > 0) {
            this.traversal = this.traversal.coalesce(new Traversal[]{__.match((Traversal[])arrayOfOptionalTraversals), __.constant((Object)"N/A")});
            for (int i = 0; i < this.optionalVariable.size(); ++i) {
                this.traversal = this.traversal.as(this.optionalVariable.get(i).substring(1), new String[0]);
            }
        }
        List vars = query.getResultVars();
        if (!query.isQueryResultStar() && !query.hasGroupBy()) {
            String[] all = new String[vars.size()];
            vars.toArray(all);
            if (query.isDistinct()) {
                this.traversal = this.traversal.dedup(all);
            }
            orderingIndex.forEach((k, v) -> {
                this.traversal = this.traversal.order().by((Traversal)__.select((String)k), (Comparator)v);
            });
            switch (all.length) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    this.traversal = this.traversal.select(all[0]);
                    break;
                }
                case 2: {
                    this.traversal = this.traversal.select(all[0], all[1], new String[0]);
                    break;
                }
                default: {
                    String[] others = Arrays.copyOfRange(all, 2, vars.size());
                    this.traversal = this.traversal.select(all[0], all[1], others);
                }
            }
        }
        if (query.hasGroupBy()) {
            VarExprList lstExpr = query.getGroupBy();
            String grpVar = "";
            for (Var expr : lstExpr.getVars()) {
                grpVar = expr.getName();
            }
            if (!grpVar.isEmpty()) {
                this.traversal = this.traversal.select(grpVar);
            }
            if (query.hasAggregators()) {
                List exprAgg = query.getAggregators();
                for (ExprAggregator expr : exprAgg) {
                    if (expr.getAggregator().getName().contains("COUNT")) {
                        if (!query.toString().contains("GROUP")) {
                            this.traversal = expr.getAggregator().toString().contains("DISTINCT") ? this.traversal.dedup(new String[]{expr.getAggregator().getExprList().get(0).toString().substring(1)}) : this.traversal.select(expr.getAggregator().getExprList().get(0).toString().substring(1));
                            this.traversal = this.traversal.count();
                        } else {
                            this.traversal = this.traversal.groupCount();
                        }
                    }
                    if (!expr.getAggregator().getName().contains("MAX")) continue;
                    this.traversal = this.traversal.max();
                }
            } else {
                this.traversal = this.traversal.group();
            }
        }
        if (query.hasOrderBy() && query.hasGroupBy()) {
            orderingIndex.forEach((k, v) -> {
                this.traversal = this.traversal.order().by((Traversal)__.select((String)k), (Comparator)v);
            });
        }
        if (query.hasLimit()) {
            long limit = query.getLimit();
            long offset = 0L;
            if (query.hasOffset()) {
                offset = query.getOffset();
            }
            this.traversal = query.hasGroupBy() && query.hasOrderBy() ? this.traversal.range(Scope.local, offset, offset + limit) : this.traversal.range(offset, offset + limit);
        }
        return this.traversal;
    }

    private static Map<String, Order> createOrderIndexFromQuery(Query query) {
        HashMap<String, Order> orderingIndex = new HashMap<String, Order>();
        if (query.hasOrderBy()) {
            List sortingConditions = query.getOrderBy();
            for (SortCondition sortCondition : sortingConditions) {
                Expr expr = sortCondition.getExpression();
                orderingIndex.put(expr.getVarName(), sortCondition.getDirection() == -1 ? Order.decr : Order.incr);
            }
        }
        return orderingIndex;
    }

    private static GraphTraversal<Vertex, ?> compile(GraphTraversalSource g, Query query) {
        return new SparqlToGremlinCompiler(g).compile(query);
    }

    private class GremlinOpVisitor
    extends OpVisitorBase {
        private GremlinOpVisitor() {
        }

        public void visit(OpBGP opBGP) {
            if (SparqlToGremlinCompiler.this.optionalFlag) {
                opBGP.getPattern().getList().forEach(triple -> SparqlToGremlinCompiler.this.optionalTraversals.add((Traversal)TraversalBuilder.transform(triple)));
                opBGP.getPattern().getList().forEach(triple -> SparqlToGremlinCompiler.this.optionalVariable.add(triple.getObject().toString()));
            } else {
                opBGP.getPattern().getList().forEach(triple -> SparqlToGremlinCompiler.this.traversalList.add(TraversalBuilder.transform(triple)));
            }
        }

        public void visit(OpFilter opFilter) {
            for (Expr expr : opFilter.getExprs().getList()) {
                if (expr == null) continue;
                GraphTraversal traversal = __.where(WhereTraversalBuilder.transform(expr));
                SparqlToGremlinCompiler.this.traversalList.add(traversal);
            }
        }

        public void visit(OpLeftJoin opLeftJoin) {
            SparqlToGremlinCompiler.this.optionalFlag = true;
            this.optionalVisit(opLeftJoin.getRight());
            if (opLeftJoin.getExprs() != null) {
                for (Expr expr : opLeftJoin.getExprs().getList()) {
                    if (expr == null || !SparqlToGremlinCompiler.this.optionalFlag) continue;
                    SparqlToGremlinCompiler.this.optionalTraversals.add((Traversal)__.where(WhereTraversalBuilder.transform(expr)));
                }
            }
        }

        private void optionalVisit(Op op) {
            OpWalker.walk((Op)op, (OpVisitor)this);
        }

        public void visit(OpUnion opUnion) {
            Traversal[] unionTemp = new Traversal[2];
            Traversal[] unionTemp1 = new Traversal[SparqlToGremlinCompiler.this.traversalList.size() / 2];
            Traversal[] unionTemp2 = new Traversal[SparqlToGremlinCompiler.this.traversalList.size() / 2];
            int count = 0;
            for (int i = 0; i < SparqlToGremlinCompiler.this.traversalList.size(); ++i) {
                if (i < SparqlToGremlinCompiler.this.traversalList.size() / 2) {
                    unionTemp1[i] = (Traversal)SparqlToGremlinCompiler.this.traversalList.get(i);
                    continue;
                }
                unionTemp2[count++] = (Traversal)SparqlToGremlinCompiler.this.traversalList.get(i);
            }
            unionTemp[1] = __.match((Traversal[])unionTemp2);
            unionTemp[0] = __.match((Traversal[])unionTemp1);
            SparqlToGremlinCompiler.this.traversalList.clear();
            SparqlToGremlinCompiler.this.traversal = SparqlToGremlinCompiler.this.traversal.union(unionTemp);
        }
    }
}

