/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import scala.Tuple2;

public final class CombineIterator<K, V, OK, OV>
implements Iterator<Tuple2<OK, OV>> {
    private final Iterator<Tuple2<K, V>> inputIterator;
    private final MapReduce<K, V, OK, OV, ?> mapReduce;
    private final CombineIteratorEmitter combineIteratorEmitter = new CombineIteratorEmitter();
    private final Map<K, List<V>> combineMap = new ConcurrentHashMap<K, List<V>>();
    private boolean combined = true;
    private static final int MAX_SIZE = 5000;

    public CombineIterator(MapReduce<K, V, OK, OV, ?> mapReduce, Iterator<Tuple2<K, V>> inputIterator) {
        this.inputIterator = inputIterator;
        this.mapReduce = mapReduce;
        this.mapReduce.workerStart(MapReduce.Stage.COMBINE);
    }

    @Override
    public boolean hasNext() {
        if (!this.combineMap.isEmpty()) {
            return true;
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.COMBINE);
            return false;
        }
        this.processNext();
        return this.hasNext();
    }

    @Override
    public Tuple2<OK, OV> next() {
        if (!this.combineMap.isEmpty()) {
            return this.nextFromCombineMap();
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.COMBINE);
            throw FastNoSuchElementException.instance();
        }
        this.processNext();
        return this.next();
    }

    private void processNext() {
        int combinedSize = this.combineMap.size();
        while (combinedSize < 5000 && this.inputIterator.hasNext()) {
            Tuple2<K, V> keyValue = this.inputIterator.next();
            List<V> values = this.combineMap.get(keyValue._1());
            if (null == values) {
                values = new ArrayList<V>();
                this.combineMap.put(keyValue._1(), values);
            }
            values.add(keyValue._2());
            this.combined = false;
            if (++combinedSize < 5000) continue;
            this.doCombine();
            combinedSize = this.combineMap.size();
        }
    }

    private void doCombine() {
        if (!this.combined) {
            for (K key : this.combineMap.keySet()) {
                List<V> values2 = this.combineMap.get(key);
                if (values2.size() <= 1) continue;
                this.combineMap.remove(key);
                this.mapReduce.combine(key, values2.iterator(), (MapReduce.ReduceEmitter)this.combineIteratorEmitter);
            }
            this.combined = true;
        }
    }

    private Tuple2<OK, OV> nextFromCombineMap() {
        this.doCombine();
        K key = this.combineMap.keySet().iterator().next();
        List<V> values = this.combineMap.get(key);
        Tuple2 keyValue = new Tuple2(key, values.remove(0));
        if (values.isEmpty()) {
            this.combineMap.remove(key);
        }
        return keyValue;
    }

    private class CombineIteratorEmitter
    implements MapReduce.ReduceEmitter<OK, OV> {
        private CombineIteratorEmitter() {
        }

        public void emit(OK key, OV value) {
            List values = CombineIterator.this.combineMap.get(key);
            if (null == values) {
                values = new ArrayList();
                CombineIterator.this.combineMap.put(key, values);
            }
            values.add(value);
        }
    }
}

