/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.configuration2.Configuration;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.PersistResultGraphAware;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.spark.structure.Spark;
import org.apache.tinkerpop.gremlin.spark.structure.io.OutputRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.SparkContextStorage;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistedOutputRDD
implements OutputRDD,
PersistResultGraphAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistedOutputRDD.class);

    @Override
    public void writeGraphRDD(Configuration configuration, JavaPairRDD<Object, VertexWritable> graphRDD) {
        if (!configuration.getBoolean("gremlin.spark.persistContext", false)) {
            LOGGER.warn("The SparkContext should be persisted in order for the RDD to persist across jobs. To do so, set gremlin.spark.persistContext to true");
        }
        if (!configuration.containsKey("gremlin.hadoop.outputLocation")) {
            throw new IllegalArgumentException("There is no provided gremlin.hadoop.outputLocation to write the persisted RDD to");
        }
        SparkContextStorage.open(configuration).rm(configuration.getString("gremlin.hadoop.outputLocation"));
        StorageLevel storageLevel = StorageLevel.fromString((String)configuration.getString("gremlin.spark.persistStorageLevel", "MEMORY_ONLY"));
        if (!configuration.getBoolean("gremlin.hadoop.graphWriter.hasEdges", true)) {
            graphRDD.mapValues((Function & Serializable)vertex -> {
                vertex.get().dropEdges(Direction.BOTH);
                return vertex;
            }).setName(Constants.getGraphLocation((String)configuration.getString("gremlin.hadoop.outputLocation"))).persist(storageLevel).count();
        } else {
            graphRDD.setName(Constants.getGraphLocation((String)configuration.getString("gremlin.hadoop.outputLocation"))).persist(storageLevel).count();
        }
        Spark.refresh();
    }

    @Override
    public <K, V> Iterator<KeyValue<K, V>> writeMemoryRDD(Configuration configuration, String memoryKey, JavaPairRDD<K, V> memoryRDD) {
        if (!configuration.getBoolean("gremlin.spark.persistContext", false)) {
            LOGGER.warn("The SparkContext should be persisted in order for the RDD to persist across jobs. To do so, set gremlin.spark.persistContext to true");
        }
        if (!configuration.containsKey("gremlin.hadoop.outputLocation")) {
            throw new IllegalArgumentException("There is no provided gremlin.hadoop.outputLocation to write the persisted RDD to");
        }
        String memoryRDDName = Constants.getMemoryLocation((String)configuration.getString("gremlin.hadoop.outputLocation"), (String)memoryKey);
        Spark.removeRDD(memoryRDDName);
        memoryRDD.setName(memoryRDDName).persist(StorageLevel.fromString((String)configuration.getString("gremlin.spark.persistStorageLevel", "MEMORY_ONLY"))).count();
        Spark.refresh();
        return IteratorUtils.map(memoryRDD.collect().iterator(), tuple -> new KeyValue(tuple._1(), tuple._2()));
    }

    public boolean supportsResultGraphPersistCombination(GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
        return persist.equals((Object)GraphComputer.Persist.NOTHING) || resultGraph.equals((Object)GraphComputer.ResultGraph.NEW);
    }
}

