/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import scala.Tuple2;

public final class MapIterator<K, V>
implements Iterator<Tuple2<K, V>> {
    private final Iterator<Tuple2<Object, VertexWritable>> inputIterator;
    private final MapReduce<K, V, ?, ?, ?> mapReduce;
    private final Queue<Tuple2<K, V>> queue = new LinkedList<Tuple2<K, V>>();
    private final MapIteratorEmitter mapIteratorEmitter = new MapIteratorEmitter();

    public MapIterator(MapReduce<K, V, ?, ?, ?> mapReduce, Iterator<Tuple2<Object, VertexWritable>> inputIterator) {
        this.inputIterator = inputIterator;
        this.mapReduce = mapReduce;
        this.mapReduce.workerStart(MapReduce.Stage.MAP);
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.MAP);
            return false;
        }
        this.processNext();
        return this.hasNext();
    }

    @Override
    public Tuple2<K, V> next() {
        if (!this.queue.isEmpty()) {
            return this.queue.remove();
        }
        if (!this.inputIterator.hasNext()) {
            this.mapReduce.workerEnd(MapReduce.Stage.MAP);
            throw FastNoSuchElementException.instance();
        }
        this.processNext();
        return this.next();
    }

    private void processNext() {
        this.mapReduce.map((Vertex)ComputerGraph.mapReduce((Vertex)((VertexWritable)this.inputIterator.next()._2()).get()), (MapReduce.MapEmitter)this.mapIteratorEmitter);
    }

    private class MapIteratorEmitter
    implements MapReduce.MapEmitter<K, V> {
        private MapIteratorEmitter() {
        }

        public void emit(K key, V value) {
            MapIterator.this.queue.add(new Tuple2(key, value));
        }
    }
}

