/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoDeserializationStream;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoSerializationStream;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.GryoSerializer;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoPool;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import scala.reflect.ClassTag;

public final class GryoSerializerInstance
extends SerializerInstance {
    private final GryoSerializer gryoSerializer;
    private final Output output;
    private final Input input;

    public GryoSerializerInstance(GryoSerializer gryoSerializer) {
        this.gryoSerializer = gryoSerializer;
        this.input = new Input();
        this.output = gryoSerializer.newOutput();
    }

    public <T> ByteBuffer serialize(T t, ClassTag<T> classTag) {
        this.gryoSerializer.getGryoPool().writeWithKryo(kryo -> kryo.writeClassAndObject(this.output, t));
        return ByteBuffer.wrap(this.output.getBuffer());
    }

    public <T> T deserialize(ByteBuffer byteBuffer, ClassTag<T> classTag) {
        this.input.setBuffer(byteBuffer.array());
        return (T)this.gryoSerializer.getGryoPool().readWithKryo(kryo -> kryo.readClassAndObject(this.input));
    }

    public <T> T deserialize(ByteBuffer byteBuffer, ClassLoader classLoader, ClassTag<T> classTag) {
        this.input.setBuffer(byteBuffer.array());
        return (T)this.gryoSerializer.getGryoPool().readWithKryo(kryo -> {
            kryo.setClassLoader(classLoader);
            return kryo.readClassAndObject(this.input);
        });
    }

    public SerializationStream serializeStream(OutputStream outputStream) {
        return new GryoSerializationStream(this, outputStream);
    }

    public DeserializationStream deserializeStream(InputStream inputStream) {
        return new GryoDeserializationStream(this, inputStream);
    }

    public GryoPool getGryoPool() {
        return this.gryoSerializer.getGryoPool();
    }
}

