/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer.payload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.MessagePayload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.Payload;
import org.apache.tinkerpop.gremlin.spark.process.computer.payload.ViewPayload;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;

public final class ViewIncomingPayload<M>
implements Payload {
    private List<DetachedVertexProperty<Object>> view = null;
    private List<M> incomingMessages;

    private ViewIncomingPayload() {
    }

    public ViewIncomingPayload(MessageCombiner<M> messageCombiner) {
        this.incomingMessages = null == messageCombiner ? new ArrayList<M>() : new ArrayList(1);
    }

    public ViewIncomingPayload(ViewPayload viewPayload) {
        this.incomingMessages = null;
        this.view = viewPayload.getView();
    }

    public List<DetachedVertexProperty<Object>> getView() {
        return null == this.view ? Collections.emptyList() : this.view;
    }

    public List<M> getIncomingMessages() {
        return null == this.incomingMessages ? Collections.emptyList() : this.incomingMessages;
    }

    public boolean hasView() {
        return null != this.view;
    }

    private void mergeMessage(M message, MessageCombiner<M> messageCombiner) {
        if (this.incomingMessages.isEmpty() || null == messageCombiner) {
            this.incomingMessages.add(message);
        } else {
            this.incomingMessages.set(0, messageCombiner.combine(this.incomingMessages.get(0), message));
        }
    }

    private void mergeViewIncomingPayload(ViewIncomingPayload<M> viewIncomingPayload, MessageCombiner<M> messageCombiner) {
        if (this.view == null) {
            this.view = viewIncomingPayload.view;
        } else {
            this.view.addAll(viewIncomingPayload.getView());
        }
        for (M message : viewIncomingPayload.getIncomingMessages()) {
            this.mergeMessage(message, messageCombiner);
        }
    }

    public void mergePayload(Payload payload, MessageCombiner<M> messageCombiner) {
        if (null == payload) {
            return;
        }
        if (payload instanceof ViewPayload) {
            this.view = ((ViewPayload)payload).getView();
        } else if (payload instanceof MessagePayload) {
            this.mergeMessage(((MessagePayload)payload).getMessage(), messageCombiner);
        } else if (payload instanceof ViewIncomingPayload) {
            this.mergeViewIncomingPayload((ViewIncomingPayload)payload, messageCombiner);
        } else {
            throw new IllegalArgumentException("The provided payload is an unsupported merge payload: " + payload);
        }
    }
}

