/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import org.apache.commons.configuration.Configuration;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.spark.structure.Spark;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.SparkContextStorage;
import org.apache.tinkerpop.gremlin.structure.io.Storage;

public final class PersistedInputRDD
implements InputRDD {
    @Override
    public JavaPairRDD<Object, VertexWritable> readGraphRDD(Configuration configuration, JavaSparkContext sparkContext) {
        if (!configuration.containsKey("gremlin.hadoop.inputLocation")) {
            throw new IllegalArgumentException("There is no provided gremlin.hadoop.inputLocation to read the persisted RDD from");
        }
        Spark.create(sparkContext.sc());
        return JavaPairRDD.fromJavaRDD((JavaRDD)Spark.getRDD((String)Constants.getSearchGraphLocation((String)configuration.getString("gremlin.hadoop.inputLocation"), (Storage)SparkContextStorage.open(sparkContext.sc())).get()).toJavaRDD());
    }

    @Override
    public <K, V> JavaPairRDD<K, V> readMemoryRDD(Configuration configuration, String memoryKey, JavaSparkContext sparkContext) {
        if (!configuration.containsKey("gremlin.hadoop.inputLocation")) {
            throw new IllegalArgumentException("There is no provided gremlin.hadoop.inputLocation to read the persisted RDD from");
        }
        return JavaPairRDD.fromJavaRDD((JavaRDD)Spark.getRDD(Constants.getMemoryLocation((String)configuration.getString("gremlin.hadoop.inputLocation"), (String)memoryKey)).toJavaRDD());
    }
}

