/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.spark.structure.io.OutputRDD;
import scala.Tuple2;

public final class OutputFormatRDD
implements OutputRDD {
    @Override
    public void writeGraphRDD(Configuration configuration, JavaPairRDD<Object, VertexWritable> graphRDD) {
        org.apache.hadoop.conf.Configuration hadoopConfiguration = ConfUtil.makeHadoopConfiguration((Configuration)configuration);
        String outputLocation = hadoopConfiguration.get("gremlin.hadoop.outputLocation");
        if (null != outputLocation) {
            graphRDD.mapToPair((PairFunction & Serializable)tuple -> new Tuple2((Object)NullWritable.get(), tuple._2())).saveAsNewAPIHadoopFile(Constants.getGraphLocation((String)outputLocation), NullWritable.class, VertexWritable.class, hadoopConfiguration.getClass("gremlin.hadoop.graphOutputFormat", OutputFormat.class), hadoopConfiguration);
        }
    }

    @Override
    public <K, V> Iterator<KeyValue<K, V>> writeMemoryRDD(Configuration configuration, String memoryKey, JavaPairRDD<K, V> memoryRDD) {
        org.apache.hadoop.conf.Configuration hadoopConfiguration = ConfUtil.makeHadoopConfiguration((Configuration)configuration);
        String outputLocation = hadoopConfiguration.get("gremlin.hadoop.outputLocation");
        if (null != outputLocation) {
            memoryRDD.mapToPair((PairFunction & Serializable)keyValue -> new Tuple2((Object)new ObjectWritable(keyValue._1()), (Object)new ObjectWritable(keyValue._2()))).saveAsNewAPIHadoopFile(Constants.getMemoryLocation((String)outputLocation, (String)memoryKey), ObjectWritable.class, ObjectWritable.class, SequenceFileOutputFormat.class, hadoopConfiguration);
            try {
                return new ObjectWritableIterator(hadoopConfiguration, new Path(Constants.getMemoryLocation((String)outputLocation, (String)memoryKey)));
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return Collections.emptyIterator();
    }
}

