/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.util.Rule;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.MemoryHelper;
import org.apache.tinkerpop.gremlin.spark.process.computer.RuleAccumulator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SparkMemory
implements Memory.Admin,
Serializable {
    public final Set<String> memoryKeys = new HashSet<String>();
    private final AtomicInteger iteration = new AtomicInteger(0);
    private final AtomicLong runtime = new AtomicLong(0L);
    private final Map<String, Accumulator<Rule>> memory = new HashMap<String, Accumulator<Rule>>();
    private Broadcast<Map<String, Object>> broadcast;
    private boolean inTask = false;

    public SparkMemory(VertexProgram<?> vertexProgram, Set<MapReduce> mapReducers, JavaSparkContext sparkContext) {
        if (null != vertexProgram) {
            for (String key : vertexProgram.getMemoryComputeKeys()) {
                MemoryHelper.validateKey((String)key);
                this.memoryKeys.add(key);
            }
        }
        for (MapReduce mapReduce : mapReducers) {
            this.memoryKeys.add(mapReduce.getMemoryKey());
        }
        for (String key : this.memoryKeys) {
            this.memory.put(key, (Accumulator<Rule>)sparkContext.accumulator((Object)new Rule(Rule.Operation.NO_OP, null), key, (AccumulatorParam)new RuleAccumulator()));
        }
        this.broadcast = sparkContext.broadcast(new HashMap());
    }

    public Set<String> keys() {
        if (this.inTask) {
            return ((Map)this.broadcast.getValue()).keySet();
        }
        HashSet trueKeys = new HashSet();
        this.memory.forEach((key, value) -> {
            if (((Rule)value.value()).getObject() != null) {
                trueKeys.add(key);
            }
        });
        return Collections.unmodifiableSet(trueKeys);
    }

    public void incrIteration() {
        this.iteration.getAndIncrement();
    }

    public void setIteration(int iteration) {
        this.iteration.set(iteration);
    }

    public int getIteration() {
        return this.iteration.get();
    }

    public void setRuntime(long runTime) {
        this.runtime.set(runTime);
    }

    public long getRuntime() {
        return this.runtime.get();
    }

    public <R> R get(String key) throws IllegalArgumentException {
        R r = this.getValue(key);
        if (null == r) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        return r;
    }

    public void incr(String key, long delta) {
        this.checkKeyValue(key, delta);
        if (this.inTask) {
            this.memory.get(key).add((Object)new Rule(Rule.Operation.INCR, (Object)delta));
        } else {
            this.memory.get(key).setValue((Object)new Rule(Rule.Operation.INCR, (Object)((Long)this.getValue(key) + delta)));
        }
    }

    public void and(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        if (this.inTask) {
            this.memory.get(key).add((Object)new Rule(Rule.Operation.AND, (Object)bool));
        } else {
            this.memory.get(key).setValue((Object)new Rule(Rule.Operation.AND, (Object)((Boolean)this.getValue(key) != false && bool ? 1 : 0)));
        }
    }

    public void or(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        if (this.inTask) {
            this.memory.get(key).add((Object)new Rule(Rule.Operation.OR, (Object)bool));
        } else {
            this.memory.get(key).setValue((Object)new Rule(Rule.Operation.OR, (Object)((Boolean)this.getValue(key) != false || bool ? 1 : 0)));
        }
    }

    public void set(String key, Object value) {
        this.checkKeyValue(key, value);
        if (this.inTask) {
            this.memory.get(key).add((Object)new Rule(Rule.Operation.SET, value));
        } else {
            this.memory.get(key).setValue((Object)new Rule(Rule.Operation.SET, value));
        }
    }

    public String toString() {
        return StringFactory.memoryString((Memory)this);
    }

    protected void setInTask(boolean inTask) {
        this.inTask = inTask;
    }

    protected void broadcastMemory(JavaSparkContext sparkContext) {
        this.broadcast.destroy(true);
        HashMap toBroadcast = new HashMap();
        this.memory.forEach((key, rule) -> {
            if (null != ((Rule)rule.value()).getObject()) {
                toBroadcast.put(key, ((Rule)rule.value()).getObject());
            }
        });
        this.broadcast = sparkContext.broadcast(toBroadcast);
    }

    private void checkKeyValue(String key, Object value) {
        if (!this.memoryKeys.contains(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)key);
        }
        MemoryHelper.validateValue((Object)value);
    }

    private <R> R getValue(String key) {
        return (R)(this.inTask ? ((Map)this.broadcast.value()).get(key) : ((Rule)this.memory.get(key).value()).getObject());
    }
}

