/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import scala.Tuple2;

public final class PersistedInputRDD
implements InputRDD {
    @Override
    public JavaPairRDD<Object, VertexWritable> readGraphRDD(Configuration configuration, JavaSparkContext sparkContext) {
        String inputRDDName = configuration.getString("gremlin.hadoop.inputLocation", null);
        if (null == inputRDDName) {
            throw new IllegalArgumentException(PersistedInputRDD.class.getSimpleName() + " requires " + "gremlin.hadoop.inputLocation" + " in order to retrieve the named graphRDD from the SparkContext");
        }
        if (!PersistedInputRDD.getPersistedRDD(sparkContext, inputRDDName).isPresent()) {
            throw new IllegalArgumentException("The provided graphRDD name is not in the persisted RDDs of the SparkContext: " + inputRDDName);
        }
        return JavaPairRDD.fromJavaRDD((JavaRDD)PersistedInputRDD.getPersistedRDD(sparkContext, inputRDDName).get().toJavaRDD());
    }

    public static Optional<RDD<?>> getPersistedRDD(JavaSparkContext sparkContext, String rddName) {
        for (Tuple2 tuple2 : JavaSparkContext.toSparkContext((JavaSparkContext)sparkContext).getPersistentRDDs().toList()) {
            if (!((RDD)tuple2._2()).toString().contains(rddName)) continue;
            return Optional.of(tuple2._2());
        }
        return Optional.empty();
    }
}

