/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.groovy.plugin;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.tinkerpop.gremlin.groovy.plugin.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginAcceptor;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginInitializationException;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer;

public final class SparkGremlinPlugin
extends AbstractGremlinPlugin {
    protected static String NAME = "tinkerpop.spark";
    protected static final Set<String> IMPORTS = new HashSet<String>(){
        {
            this.add("import org.apache.log4j.*");
            this.add("import " + SparkGraphComputer.class.getPackage().getName() + ".*");
        }
    };

    public String getName() {
        return NAME;
    }

    public void afterPluginTo(PluginAcceptor pluginAcceptor) throws PluginInitializationException, IllegalEnvironmentException {
        pluginAcceptor.addImports(IMPORTS);
        try {
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.INFO)", SparkGraphComputer.class.getName()));
            pluginAcceptor.eval(String.format("Logger.getLogger(%s).setLevel(Level.ERROR)", MetricsSystem.class.getName()));
        }
        catch (Exception e) {
            throw new PluginInitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean requireRestart() {
        return true;
    }

    public Optional<RemoteAcceptor> remoteAcceptor() {
        return Optional.empty();
    }
}

