/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphVariableHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;

@Deprecated
public final class Neo4jGraphVariables
implements Graph.Variables {
    private final Neo4jGraph graph;
    private final Neo4jGraphAPI baseGraph;

    protected Neo4jGraphVariables(Neo4jGraph graph) {
        this.graph = graph;
        this.baseGraph = graph.getBaseGraph();
    }

    public Set<String> keys() {
        this.graph.tx().readWrite();
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.baseGraph.getKeys()) {
            if (Graph.Hidden.isHidden((String)key)) continue;
            keys.add(key);
        }
        return keys;
    }

    public <R> Optional<R> get(String key) {
        this.graph.tx().readWrite();
        return this.baseGraph.hasProperty(key) ? Optional.of(this.baseGraph.getProperty(key)) : Optional.empty();
    }

    public void set(String key, Object value) {
        GraphVariableHelper.validateVariable((String)key, (Object)value);
        this.graph.tx().readWrite();
        try {
            this.baseGraph.setProperty(key, value);
        }
        catch (IllegalArgumentException e) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)value, (Exception)e);
        }
    }

    public void remove(String key) {
        this.graph.tx().readWrite();
        if (this.baseGraph.hasProperty(key)) {
            this.baseGraph.removeProperty(key);
        }
    }

    public String toString() {
        return StringFactory.graphVariablesString((Graph.Variables)this);
    }

    public static class Neo4jVariableFeatures
    implements Graph.Features.VariableFeatures {
        public boolean supportsBooleanValues() {
            return true;
        }

        public boolean supportsDoubleValues() {
            return true;
        }

        public boolean supportsFloatValues() {
            return true;
        }

        public boolean supportsIntegerValues() {
            return true;
        }

        public boolean supportsLongValues() {
            return true;
        }

        public boolean supportsMapValues() {
            return false;
        }

        public boolean supportsMixedListValues() {
            return false;
        }

        public boolean supportsByteValues() {
            return false;
        }

        public boolean supportsBooleanArrayValues() {
            return true;
        }

        public boolean supportsByteArrayValues() {
            return false;
        }

        public boolean supportsDoubleArrayValues() {
            return true;
        }

        public boolean supportsFloatArrayValues() {
            return true;
        }

        public boolean supportsIntegerArrayValues() {
            return true;
        }

        public boolean supportsLongArrayValues() {
            return true;
        }

        public boolean supportsStringArrayValues() {
            return true;
        }

        public boolean supportsSerializableValues() {
            return false;
        }

        public boolean supportsStringValues() {
            return true;
        }

        public boolean supportsUniformListValues() {
            return false;
        }
    }
}

