/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jElement;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jHelper;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jProperty;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedEdge;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.neo4j.tinkerpop.api.Neo4jEntity;
import org.neo4j.tinkerpop.api.Neo4jRelationship;

public final class Neo4jEdge
extends Neo4jElement
implements Edge,
WrappedEdge<Neo4jRelationship> {
    public Neo4jEdge(Neo4jRelationship relationship, Neo4jGraph graph) {
        super((Neo4jEntity)relationship, graph);
    }

    public Vertex outVertex() {
        return new Neo4jVertex(this.getBaseEdge().start(), this.graph);
    }

    public Vertex inVertex() {
        return new Neo4jVertex(this.getBaseEdge().end(), this.graph);
    }

    public Iterator<Vertex> vertices(Direction direction) {
        this.graph.tx().readWrite();
        switch (direction) {
            case OUT: {
                return IteratorUtils.of((Object)new Neo4jVertex(this.getBaseEdge().start(), this.graph));
            }
            case IN: {
                return IteratorUtils.of((Object)new Neo4jVertex(this.getBaseEdge().end(), this.graph));
            }
        }
        return IteratorUtils.of((Object)new Neo4jVertex(this.getBaseEdge().start(), this.graph), (Object)new Neo4jVertex(this.getBaseEdge().end(), this.graph));
    }

    public void remove() {
        block3: {
            this.graph.tx().readWrite();
            try {
                this.baseElement.delete();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RuntimeException e) {
                if (Neo4jHelper.isNotFound(e)) break block3;
                throw e;
            }
        }
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public String label() {
        this.graph.tx().readWrite();
        return this.getBaseEdge().type();
    }

    public Neo4jRelationship getBaseEdge() {
        return (Neo4jRelationship)this.baseElement;
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        this.graph.tx().readWrite();
        Iterable keys = this.baseElement.getKeys();
        Iterator filter = IteratorUtils.filter(keys.iterator(), key -> ElementHelper.keyExists((String)key, (String[])propertyKeys));
        return IteratorUtils.map((Iterator)filter, key -> new Neo4jProperty<Object>(this, (String)key, this.baseElement.getProperty(key)));
    }

    public <V> Property<V> property(String key) {
        this.graph.tx().readWrite();
        if (this.baseElement.hasProperty(key)) {
            return new Neo4jProperty<Object>(this, key, this.baseElement.getProperty(key));
        }
        return Property.empty();
    }

    public <V> Property<V> property(String key, V value) {
        ElementHelper.validateProperty((String)key, value);
        if (null == value) {
            this.properties(key).forEachRemaining(Property::remove);
            return Property.empty();
        }
        this.graph.tx().readWrite();
        try {
            this.baseElement.setProperty(key, value);
            return new Neo4jProperty<V>(this, key, value);
        }
        catch (IllegalArgumentException e) {
            throw Property.Exceptions.dataTypeOfPropertyValueNotSupported(value, (Exception)e);
        }
    }
}

