/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.process.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.neo4j.process.traversal.step.sideEffect.Neo4jGraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class Neo4jGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Neo4jGraphStepStrategy INSTANCE = new Neo4jGraphStepStrategy();

    private Neo4jGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        for (GraphStep originalGraphStep : TraversalHelper.getStepsOfClass(GraphStep.class, traversal)) {
            Neo4jGraphStep neo4jGraphStep = new Neo4jGraphStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)originalGraphStep, neo4jGraphStep, traversal);
            Step currentStep = neo4jGraphStep.getNextStep();
            while (currentStep instanceof HasStep || currentStep instanceof NoOpBarrierStep) {
                if (currentStep instanceof HasStep) {
                    for (HasContainer hasContainer : ((HasContainerHolder)currentStep).getHasContainers()) {
                        if (GraphStep.processHasContainerIds(neo4jGraphStep, (HasContainer)hasContainer)) continue;
                        neo4jGraphStep.addHasContainer(hasContainer);
                    }
                    TraversalHelper.copyLabels((Step)currentStep, (Step)currentStep.getPreviousStep(), (boolean)false);
                    traversal.removeStep(currentStep);
                }
                currentStep = currentStep.getNextStep();
            }
        }
    }

    public static Neo4jGraphStepStrategy instance() {
        return INSTANCE;
    }
}

