/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.neo4j.process.traversal.LabelP;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Text;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.neo4j.tinkerpop.api.Neo4jGraphAPI;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jStringSearchMode;

public final class Neo4jGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public Neo4jGraphStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(arg_0 -> ((Neo4jGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        return IteratorUtils.filter((Iterator)((Graph)this.getTraversal().getGraph().get()).edges(this.ids), edge -> HasContainer.testAll((Element)edge, this.hasContainers));
    }

    private Iterator<? extends Vertex> vertices() {
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        Neo4jGraph graph = (Neo4jGraph)this.getTraversal().getGraph().get();
        if (this.ids.length > 0) {
            return IteratorUtils.filter(graph.vertices(this.ids), vertex -> HasContainer.testAll((Element)vertex, this.hasContainers));
        }
        graph.tx().readWrite();
        Optional<String> label = this.hasContainers.stream().filter(hasContainer -> hasContainer.getKey() != null && hasContainer.getKey().equals(T.label.getAccessor())).filter(hasContainer -> Compare.eq == hasContainer.getBiPredicate()).filter(hasContainer -> hasContainer.getValue() != null).map(hasContainer -> (String)hasContainer.getValue()).findAny();
        if (!label.isPresent()) {
            label = this.hasContainers.stream().filter(hasContainer -> hasContainer.getKey() != null && hasContainer.getKey().equals(T.label.getAccessor())).filter(hasContainer -> hasContainer.getPredicate() instanceof LabelP).filter(hasContainer -> hasContainer.getValue() != null).map(hasContainer -> (String)hasContainer.getValue()).findAny();
        }
        if (label.isPresent()) {
            String labelValue = label.get();
            Neo4jGraphAPI baseGraph = graph.getBaseGraph();
            for (HasContainer hasContainer2 : this.hasContainers) {
                String key = hasContainer2.getKey();
                Object value = hasContainer2.getValue();
                if (key == null || key.equals(T.label.getAccessor()) || !baseGraph.hasSchemaIndex(labelValue, key)) continue;
                BiPredicate predicate = hasContainer2.getBiPredicate();
                Iterable nodes = null;
                if (Compare.eq == predicate) {
                    nodes = baseGraph.findNodes(labelValue, key, value);
                } else if (Text.containing == predicate) {
                    nodes = baseGraph.findNodes(labelValue, key, value.toString(), Neo4jStringSearchMode.CONTAINS);
                } else if (Text.startingWith == predicate) {
                    nodes = baseGraph.findNodes(labelValue, key, value.toString(), Neo4jStringSearchMode.PREFIX);
                } else if (Text.endingWith == predicate) {
                    nodes = baseGraph.findNodes(labelValue, key, value.toString(), Neo4jStringSearchMode.SUFFIX);
                }
                if (nodes == null) continue;
                return IteratorUtils.stream((Iterable)nodes).map(node -> new Neo4jVertex((Neo4jNode)node, graph)).filter(vertex -> HasContainer.testAll((Element)vertex, this.hasContainers)).iterator();
            }
            return IteratorUtils.stream((Iterable)graph.getBaseGraph().findNodes(label.get())).map(node -> new Neo4jVertex((Neo4jNode)node, graph)).filter(vertex -> HasContainer.testAll((Element)vertex, this.hasContainers)).iterator();
        }
        return IteratorUtils.filter(graph.vertices(new Object[0]), vertex -> HasContainer.testAll((Element)vertex, this.hasContainers));
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.hasContainers.hashCode();
    }
}

