/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertexProperty;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.neo4j.tinkerpop.api.Neo4jDirection;
import org.neo4j.tinkerpop.api.Neo4jNode;

public final class Neo4jHelper {
    private static final String NOT_FOUND_EXCEPTION = "NotFoundException";

    private Neo4jHelper() {
    }

    public static Neo4jDirection mapDirection(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return Neo4jDirection.OUTGOING;
        }
        if (direction.equals((Object)Direction.IN)) {
            return Neo4jDirection.INCOMING;
        }
        return Neo4jDirection.BOTH;
    }

    public static boolean isDeleted(Neo4jNode node) {
        try {
            node.getKeys();
            return false;
        }
        catch (RuntimeException e) {
            if (Neo4jHelper.isNotFound(e)) {
                return true;
            }
            throw e;
        }
    }

    public static boolean isNotFound(RuntimeException ex) {
        return ex.getClass().getSimpleName().equals(NOT_FOUND_EXCEPTION);
    }

    public static Neo4jNode getVertexPropertyNode(Neo4jVertexProperty vertexProperty) {
        return vertexProperty.vertexPropertyNode;
    }

    public static void setVertexPropertyNode(Neo4jVertexProperty vertexProperty, Neo4jNode node) {
        vertexProperty.vertexPropertyNode = node;
    }
}

