/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jEdge;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jElement;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.neo4j.tinkerpop.api.Neo4jEntity;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;

public final class Neo4jVertex
extends Neo4jElement
implements Vertex,
WrappedVertex<Neo4jNode> {
    public static final String LABEL_DELIMINATOR = "::";

    public Neo4jVertex(Neo4jNode node, Neo4jGraph graph) {
        super((Neo4jEntity)node, graph);
    }

    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        if (null == inVertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"inVertex");
        }
        ElementHelper.validateLabel((String)label);
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        this.graph.tx().readWrite();
        Neo4jNode node = (Neo4jNode)this.baseElement;
        Neo4jEdge edge = new Neo4jEdge(node.connectTo(((Neo4jVertex)inVertex).getBaseVertex(), label), this.graph);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        return edge;
    }

    public <V> VertexProperty<V> property(String key, V value) {
        return this.property(VertexProperty.Cardinality.single, key, value, new Object[0]);
    }

    public void remove() {
        this.graph.tx().readWrite();
        this.graph.trait.removeVertex(this);
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        ElementHelper.validateProperty((String)key, value);
        if (ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        this.graph.tx().readWrite();
        return this.graph.trait.setVertexProperty(this, cardinality, key, value, keyValues);
    }

    public <V> VertexProperty<V> property(String key) {
        this.graph.tx().readWrite();
        return this.graph.trait.getVertexProperty(this, key);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        this.graph.tx().readWrite();
        return this.graph.trait.getVertexProperties(this, propertyKeys);
    }

    public Neo4jNode getBaseVertex() {
        return (Neo4jNode)this.baseElement;
    }

    public String label() {
        this.graph.tx().readWrite();
        return String.join((CharSequence)LABEL_DELIMINATOR, this.labels());
    }

    public Iterator<Vertex> vertices(final Direction direction, final String ... edgeLabels) {
        this.graph.tx().readWrite();
        return new Iterator<Vertex>(){
            final Iterator<Neo4jRelationship> relationshipIterator;
            {
                this.relationshipIterator = IteratorUtils.filter(0 == edgeLabels.length ? Neo4jVertex.this.getBaseVertex().relationships(Neo4jHelper.mapDirection(direction), new String[0]).iterator() : Neo4jVertex.this.getBaseVertex().relationships(Neo4jHelper.mapDirection(direction), edgeLabels).iterator(), Neo4jVertex.this.graph.trait.getRelationshipPredicate());
            }

            @Override
            public boolean hasNext() {
                return this.relationshipIterator.hasNext();
            }

            @Override
            public Neo4jVertex next() {
                return new Neo4jVertex(this.relationshipIterator.next().other(Neo4jVertex.this.getBaseVertex()), Neo4jVertex.this.graph);
            }
        };
    }

    public Iterator<Edge> edges(final Direction direction, final String ... edgeLabels) {
        this.graph.tx().readWrite();
        return new Iterator<Edge>(){
            final Iterator<Neo4jRelationship> relationshipIterator;
            {
                this.relationshipIterator = IteratorUtils.filter(0 == edgeLabels.length ? Neo4jVertex.this.getBaseVertex().relationships(Neo4jHelper.mapDirection(direction), new String[0]).iterator() : Neo4jVertex.this.getBaseVertex().relationships(Neo4jHelper.mapDirection(direction), edgeLabels).iterator(), Neo4jVertex.this.graph.trait.getRelationshipPredicate());
            }

            @Override
            public boolean hasNext() {
                return this.relationshipIterator.hasNext();
            }

            @Override
            public Neo4jEdge next() {
                return new Neo4jEdge(this.relationshipIterator.next(), Neo4jVertex.this.graph);
            }
        };
    }

    public Set<String> labels() {
        this.graph.tx().readWrite();
        TreeSet labels = new TreeSet(this.getBaseVertex().labels());
        return Collections.unmodifiableSet(labels);
    }

    public void addLabel(String label) {
        this.graph.tx().readWrite();
        this.getBaseVertex().addLabel(label);
    }

    public void removeLabel(String label) {
        this.graph.tx().readWrite();
        this.getBaseVertex().removeLabel(label);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }
}

