/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.neo4j.tinkerpop.api.Neo4jNode;

public final class Neo4jVertexProperty<V>
implements VertexProperty<V> {
    protected final Neo4jVertex vertex;
    protected final String key;
    protected final V value;
    protected Neo4jNode vertexPropertyNode;

    public Neo4jVertexProperty(Neo4jVertex vertex, String key, V value) {
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        this.vertexPropertyNode = null;
    }

    public Neo4jVertexProperty(Neo4jVertex vertex, String key, V value, Neo4jNode vertexPropertyNode) {
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        this.vertexPropertyNode = vertexPropertyNode;
    }

    public Neo4jVertexProperty(Neo4jVertex vertex, Neo4jNode vertexPropertyNode) {
        this.vertex = vertex;
        this.key = (String)vertexPropertyNode.getProperty(T.key.getAccessor());
        this.value = vertexPropertyNode.getProperty(T.value.getAccessor());
        this.vertexPropertyNode = vertexPropertyNode;
    }

    public Vertex element() {
        return this.vertex;
    }

    public Object id() {
        return (long)(this.key.hashCode() + this.value.hashCode() + this.vertex.id().hashCode());
    }

    public String key() {
        return this.key;
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        this.vertex.graph.tx().readWrite();
        return this.vertex.graph.trait.getProperties(this, propertyKeys);
    }

    public <U> Property<U> property(String key, U value) {
        this.vertex.graph.tx().readWrite();
        ElementHelper.validateProperty((String)key, value);
        return this.vertex.graph.trait.setProperty(this, key, value);
    }

    public void remove() {
        this.vertex.graph.tx().readWrite();
        this.vertex.graph.trait.removeVertexProperty(this);
        this.vertexPropertyNode = null;
    }

    public Set<String> keys() {
        if (null == this.vertexPropertyNode) {
            return Collections.emptySet();
        }
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.vertexPropertyNode.getKeys()) {
            if (Graph.Hidden.isHidden((String)key) || key.equals(this.key)) continue;
            keys.add(key);
        }
        return Collections.unmodifiableSet(keys);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((VertexProperty)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }
}

