/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.io.util.IoRegistryHelper;

public final class GraphSONRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private final DataOutputStream outputStream;
    private final boolean hasEdges;
    private final GraphSONWriter graphsonWriter;

    public GraphSONRecordWriter(DataOutputStream outputStream, org.apache.hadoop.conf.Configuration configuration) {
        this.outputStream = outputStream;
        this.hasEdges = configuration.getBoolean("gremlin.hadoop.graphWriter.hasEdges", true);
        GraphSONVersion graphSONVersion = GraphSONVersion.valueOf((String)configuration.get("gremlin.hadoop.graphSONVersion", "V3_0"));
        GraphSONMapper mapper = ((GraphSONMapper.Builder)GraphSONMapper.build().version(graphSONVersion).typeInfo(TypeInfo.PARTIAL_TYPES).addDefaultXModule(true).addRegistries(IoRegistryHelper.createRegistries((Configuration)ConfUtil.makeApacheConfiguration(configuration)))).create();
        this.graphsonWriter = GraphSONWriter.build().mapper((Mapper)mapper).create();
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            if (this.hasEdges) {
                this.graphsonWriter.writeVertex((OutputStream)this.outputStream, (Vertex)vertex.get(), Direction.BOTH);
                this.outputStream.write(NEWLINE);
            } else {
                this.graphsonWriter.writeVertex((OutputStream)this.outputStream, (Vertex)vertex.get());
                this.outputStream.write(NEWLINE);
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.outputStream.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

