/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.util;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;

public final class ConfUtil {
    private ConfUtil() {
    }

    public static Configuration makeApacheConfiguration(org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        hadoopConfiguration.iterator().forEachRemaining(e -> apacheConfiguration.setProperty((String)e.getKey(), e.getValue()));
        return apacheConfiguration;
    }

    public static org.apache.hadoop.conf.Configuration makeHadoopConfiguration(Configuration apacheConfiguration) {
        org.apache.hadoop.conf.Configuration hadoopConfiguration = new org.apache.hadoop.conf.Configuration();
        apacheConfiguration.getKeys().forEachRemaining(key -> {
            Object object = apacheConfiguration.getProperty(key);
            hadoopConfiguration.set(key, object.toString());
        });
        return hadoopConfiguration;
    }

    public static void mergeApacheIntoHadoopConfiguration(Configuration apacheConfiguration, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        apacheConfiguration.getKeys().forEachRemaining(key -> {
            Object object = apacheConfiguration.getProperty(key);
            hadoopConfiguration.set(key, object.toString());
        });
    }

    public static InputFormat<NullWritable, VertexWritable> getReaderAsInputFormat(org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        Class readerClass = hadoopConfiguration.getClass("gremlin.hadoop.graphReader", Object.class);
        try {
            return InputFormat.class.isAssignableFrom(readerClass) ? (InputFormat)readerClass.newInstance() : (InputFormat)Class.forName("org.apache.tinkerpop.gremlin.spark.structure.io.InputRDDFormat").newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

