/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.FileSystemStorage;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.Element;

public abstract class HadoopElementIterator<E extends Element>
implements Iterator<E>,
AutoCloseable {
    protected final HadoopGraph graph;
    protected final Queue<RecordReader<NullWritable, VertexWritable>> readers = new LinkedList<RecordReader<NullWritable, VertexWritable>>();

    public HadoopElementIterator(HadoopGraph graph) {
        try {
            this.graph = graph;
            org.apache.hadoop.conf.Configuration configuration = ConfUtil.makeHadoopConfiguration((Configuration)this.graph.configuration());
            InputFormat<NullWritable, VertexWritable> inputFormat = ConfUtil.getReaderAsInputFormat(configuration);
            if (inputFormat instanceof FileInputFormat) {
                FileSystemStorage storage = FileSystemStorage.open(configuration);
                if (!this.graph.configuration().containsKey("gremlin.hadoop.inputLocation")) {
                    return;
                }
                if (!Constants.getSearchGraphLocation(this.graph.configuration().getInputLocation(), storage).isPresent()) {
                    return;
                }
                configuration.set("mapreduce.input.fileinputformat.inputdir", Constants.getSearchGraphLocation(this.graph.configuration().getInputLocation(), storage).get());
            }
            List splits = inputFormat.getSplits((JobContext)new JobContextImpl(configuration, new JobID(UUID.randomUUID().toString(), 1)));
            for (InputSplit split : splits) {
                this.readers.add((RecordReader<NullWritable, VertexWritable>)inputFormat.createRecordReader(split, (TaskAttemptContext)new TaskAttemptContextImpl(configuration, new TaskAttemptID())));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            for (RecordReader recordReader : this.readers) {
                recordReader.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

