/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectWritable<T>
implements WritableComparable<ObjectWritable>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ObjectWritable.class);
    private static final ObjectWritable<MapReduce.NullObject> NULL_OBJECT_WRITABLE = new ObjectWritable<MapReduce.NullObject>(MapReduce.NullObject.instance());
    T t;

    public ObjectWritable() {
    }

    public ObjectWritable(T t) {
        this.set(t);
    }

    public T get() {
        return this.t;
    }

    public void set(T t) {
        this.t = t;
    }

    public String toString() {
        int maxAttempts = 5;
        int i = 5;
        while (true) {
            try {
                return Objects.toString(this.t);
            }
            catch (ConcurrentModificationException cme) {
                block6: {
                    if (--i > 0) {
                        logger.warn(String.format("Failed to toString() object held by ObjectWritable, retrying %d more %s.", i, i == 1 ? "time" : "times"), (Throwable)cme);
                        if (i >= 4) continue;
                        try {
                            Thread.sleep((5 - i - 1) * 100);
                        }
                        catch (InterruptedException ignored) {
                            break block6;
                        }
                        continue;
                    }
                }
                return this.t.getClass().toString();
            }
            break;
        }
    }

    public void readFields(DataInput input) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(WritableUtils.readCompressedByteArray((DataInput)input));
        this.t = KryoShimServiceLoader.readClassAndObject((InputStream)bais);
    }

    public void write(DataOutput output) throws IOException {
        byte[] serialized = KryoShimServiceLoader.writeClassAndObjectToBytes(this.t);
        WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])serialized);
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        this.write(outputStream);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.readFields(inputStream);
    }

    public int compareTo(ObjectWritable objectWritable) {
        if (null == this.t) {
            return objectWritable.isEmpty() ? 0 : -1;
        }
        if (this.t instanceof Comparable && !objectWritable.isEmpty()) {
            return ((Comparable)this.t).compareTo(objectWritable.get());
        }
        if (this.t.equals(objectWritable.get())) {
            return 0;
        }
        return -1;
    }

    public boolean isEmpty() {
        return null == this.t;
    }

    public static <A> ObjectWritable<A> empty() {
        return new ObjectWritable<Object>(null);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObjectWritable)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((ObjectWritable)other).isEmpty();
        }
        return this.t.equals(((ObjectWritable)other).get());
    }

    public int hashCode() {
        return null == this.t ? 0 : this.t.hashCode();
    }

    public static ObjectWritable<MapReduce.NullObject> getNullObjectWritable() {
        return NULL_OBJECT_WRITABLE;
    }
}

