/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer;

import java.io.IOException;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.util.ComputerGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopMap
extends Mapper<NullWritable, VertexWritable, ObjectWritable, ObjectWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopMap.class);
    private MapReduce mapReduce;
    private final HadoopMapEmitter<ObjectWritable, ObjectWritable> mapEmitter = new HadoopMapEmitter();

    private HadoopMap() {
    }

    public void setup(Mapper.Context context) {
        Configuration apacheConfiguration = ConfUtil.makeApacheConfiguration(context.getConfiguration());
        KryoShimServiceLoader.applyConfiguration((Configuration)apacheConfiguration);
        this.mapReduce = MapReduce.createMapReduce((Graph)HadoopGraph.open(apacheConfiguration), (Configuration)apacheConfiguration);
        this.mapReduce.workerStart(MapReduce.Stage.MAP);
    }

    public void map(NullWritable key, VertexWritable value, Mapper.Context context) throws IOException, InterruptedException {
        this.mapEmitter.setContext(context);
        this.mapReduce.map((Vertex)ComputerGraph.mapReduce((Vertex)value.get()), this.mapEmitter);
    }

    public void cleanup(Mapper.Context context) {
        this.mapReduce.workerEnd(MapReduce.Stage.MAP);
    }

    public class HadoopMapEmitter<K, V>
    implements MapReduce.MapEmitter<K, V> {
        private Mapper.Context context;
        private final ObjectWritable<K> keyWritable = new ObjectWritable();
        private final ObjectWritable<V> valueWritable = new ObjectWritable();

        public void setContext(Mapper.Context context) {
            this.context = context;
        }

        public void emit(K key, V value) {
            this.keyWritable.set(key);
            this.valueWritable.set(value);
            try {
                this.context.write(this.keyWritable, this.valueWritable);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

