/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.GraphFilterInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.HadoopCombine;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.HadoopMap;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.HadoopReduce;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.InputOutputHelper;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableComparator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;

public final class MapReduceHelper {
    private MapReduceHelper() {
    }

    public static void executeMapReduceJob(MapReduce mapReduce, Memory.Admin memory, org.apache.hadoop.conf.Configuration configuration) throws IOException, ClassNotFoundException, InterruptedException {
        boolean vertexProgramExists;
        org.apache.hadoop.conf.Configuration newConfiguration = new org.apache.hadoop.conf.Configuration(configuration);
        boolean bl = vertexProgramExists = newConfiguration.get("gremlin.vertexProgram", null) != null;
        if (vertexProgramExists) {
            newConfiguration.set("gremlin.hadoop.graphReader", InputOutputHelper.getInputFormat(newConfiguration.getClass("gremlin.hadoop.graphWriter", OutputFormat.class)).getCanonicalName());
            newConfiguration.unset("gremlin.hadoop.graphFilter");
        }
        BaseConfiguration apacheConfiguration = new BaseConfiguration();
        mapReduce.storeState((Configuration)apacheConfiguration);
        ConfUtil.mergeApacheIntoHadoopConfiguration((Configuration)apacheConfiguration, newConfiguration);
        Optional mapSort = mapReduce.getMapKeySort();
        Optional reduceSort = mapReduce.getReduceKeySort();
        newConfiguration.setClass("gremlin.hadoop.mapReduceClass", mapReduce.getClass(), MapReduce.class);
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)newConfiguration, (String)mapReduce.toString());
        HadoopGraph.LOGGER.info("HadoopGremlin: " + mapReduce.toString());
        job.setJarByClass(HadoopGraph.class);
        if (mapSort.isPresent()) {
            job.setSortComparatorClass(ObjectWritableComparator.ObjectWritableMapComparator.class);
        }
        job.setMapperClass(HadoopMap.class);
        if (mapReduce.doStage(MapReduce.Stage.REDUCE)) {
            if (mapReduce.doStage(MapReduce.Stage.COMBINE)) {
                job.setCombinerClass(HadoopCombine.class);
            }
            job.setReducerClass(HadoopReduce.class);
        } else if (mapSort.isPresent()) {
            job.setReducerClass(Reducer.class);
            job.setNumReduceTasks(1);
        } else {
            job.setNumReduceTasks(0);
        }
        job.setMapOutputKeyClass(ObjectWritable.class);
        job.setMapOutputValueClass(ObjectWritable.class);
        job.setOutputKeyClass(ObjectWritable.class);
        job.setOutputValueClass(ObjectWritable.class);
        job.setInputFormatClass(GraphFilterInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        Path graphPath = vertexProgramExists ? new Path(Constants.getGraphLocation(newConfiguration.get("gremlin.hadoop.outputLocation"))) : new Path(newConfiguration.get("gremlin.hadoop.inputLocation"));
        Path memoryPath = new Path(Constants.getMemoryLocation(newConfiguration.get("gremlin.hadoop.outputLocation"), reduceSort.isPresent() ? mapReduce.getMemoryKey() + "-temp" : mapReduce.getMemoryKey()));
        if (FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).exists(memoryPath)) {
            FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).delete(memoryPath, true);
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{graphPath});
        FileOutputFormat.setOutputPath((Job)job, (Path)memoryPath);
        job.waitForCompletion(true);
        if (reduceSort.isPresent()) {
            Job reduceSortJob = Job.getInstance((org.apache.hadoop.conf.Configuration)newConfiguration, (String)"ReduceKeySort");
            reduceSortJob.setSortComparatorClass(ObjectWritableComparator.ObjectWritableReduceComparator.class);
            reduceSortJob.setMapperClass(Mapper.class);
            reduceSortJob.setReducerClass(Reducer.class);
            reduceSortJob.setMapOutputKeyClass(ObjectWritable.class);
            reduceSortJob.setMapOutputValueClass(ObjectWritable.class);
            reduceSortJob.setOutputKeyClass(ObjectWritable.class);
            reduceSortJob.setOutputValueClass(ObjectWritable.class);
            reduceSortJob.setInputFormatClass(SequenceFileInputFormat.class);
            reduceSortJob.setOutputFormatClass(SequenceFileOutputFormat.class);
            reduceSortJob.setNumReduceTasks(1);
            FileInputFormat.setInputPaths((Job)reduceSortJob, (Path[])new Path[]{memoryPath});
            Path sortedMemoryPath = new Path(Constants.getMemoryLocation(newConfiguration.get("gremlin.hadoop.outputLocation"), mapReduce.getMemoryKey()));
            FileOutputFormat.setOutputPath((Job)reduceSortJob, (Path)sortedMemoryPath);
            reduceSortJob.waitForCompletion(true);
            FileSystem.get((org.apache.hadoop.conf.Configuration)newConfiguration).delete(memoryPath, true);
            memoryPath = sortedMemoryPath;
        }
        mapReduce.addResultToMemory(memory, (Iterator)new ObjectWritableIterator(newConfiguration, memoryPath));
    }
}

