/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopEdge;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopElementIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;

public final class HadoopEdgeIterator
extends HadoopElementIterator<Edge> {
    private Iterator<Edge> edgeIterator = Collections.emptyIterator();

    public HadoopEdgeIterator(HadoopGraph graph) throws IOException {
        super(graph);
    }

    @Override
    public Edge next() {
        try {
            while (true) {
                if (this.edgeIterator.hasNext()) {
                    return new HadoopEdge(this.edgeIterator.next(), this.graph);
                }
                if (this.readers.isEmpty()) {
                    throw FastNoSuchElementException.instance();
                }
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    this.edgeIterator = ((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get().edges(Direction.OUT, new String[0]);
                    continue;
                }
                ((RecordReader)this.readers.remove()).close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            while (true) {
                if (this.edgeIterator.hasNext()) {
                    return true;
                }
                if (this.readers.isEmpty()) {
                    return false;
                }
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    this.edgeIterator = ((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get().edges(Direction.OUT, new String[0]);
                    continue;
                }
                ((RecordReader)this.readers.remove()).close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

