/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.AbstractHadoopGraphComputer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopEdgeIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopVertexIterator;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite")})
@Graph.OptOuts(value={@Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_knows_b__c_knows_bX", reason="Giraph does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though.", computers={"org.apache.tinkerpop.gremlin.giraph.process.computer.GiraphGraphComputer"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_matchXa_created_b__c_created_bX_selectXa_b_cX_byXnameX", reason="Giraph does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though.", computers={"org.apache.tinkerpop.gremlin.giraph.process.computer.GiraphGraphComputer"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$Traversals", method="g_V_out_asXcX_matchXb_knows_a__c_created_eX_selectXcX", reason="Giraph does a hard kill on failure and stops threads which stops test cases. Exception handling semantics are correct though.", computers={"org.apache.tinkerpop.gremlin.giraph.process.computer.GiraphGraphComputer"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_both_both_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX3X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX8X_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.CountTest$Traversals", method="g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="grateful_V_out_out_profile", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest$Traversals", method="grateful_V_out_out_profileXmetricsX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupTest", method="g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupTest", method="g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupTest", method="g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupTest", method="g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.GraphComputerTest", method="shouldStartAndEndWorkersForVertexProgramAndMapReduce", reason="Spark executes map and combine in a lazy fashion and thus, fails the blocking aspect of this test", computers={"org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionTest", method="*", reason="The interruption model in the test can't guarantee interruption at the right time with HadoopGraph."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionComputerTest", method="*", reason="This test makes use of a sideEffect to enforce when a thread interruption is triggered and thus isn't applicable to HadoopGraph", computers={"org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer", "org.apache.tinkerpop.gremlin.giraph.process.computer.GiraphGraphComputer"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$CountMatchTraversals", method="g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"}), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchTest$GreedyMatchTraversals", method="g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count", reason="Hadoop-Gremlin is OLAP-oriented and for OLTP operations, linear-scan joins are required. This particular tests takes many minutes to execute.", computers={"ALL"})})
public final class HadoopGraph
implements Graph {
    public static final Logger LOGGER = LoggerFactory.getLogger(HadoopGraph.class);
    private static final Configuration EMPTY_CONFIGURATION = new BaseConfiguration(){
        {
            this.setProperty("gremlin.graph", HadoopGraph.class.getName());
        }
    };
    protected final HadoopConfiguration configuration;

    private HadoopGraph(Configuration configuration) {
        this.configuration = new HadoopConfiguration(configuration);
    }

    public static HadoopGraph open() {
        return HadoopGraph.open(EMPTY_CONFIGURATION);
    }

    public static HadoopGraph open(Configuration configuration) {
        return new HadoopGraph(Optional.ofNullable(configuration).orElse(EMPTY_CONFIGURATION));
    }

    public static HadoopGraph open(String configurationFile) throws ConfigurationException {
        if (null == configurationFile) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"configurationFile");
        }
        return HadoopGraph.open((Configuration)new PropertiesConfiguration(configurationFile));
    }

    public Vertex addVertex(Object ... keyValues) {
        throw Graph.Exceptions.vertexAdditionsNotSupported();
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        try {
            if (AbstractHadoopGraphComputer.class.isAssignableFrom(graphComputerClass)) {
                return (C)((GraphComputer)graphComputerClass.getConstructor(HadoopGraph.class).newInstance(this));
            }
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public GraphComputer compute() {
        if (this.configuration.containsKey("gremlin.hadoop.defaultGraphComputer")) {
            try {
                return this.compute(Class.forName(this.configuration.getString("gremlin.hadoop.defaultGraphComputer")));
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("There is no default GraphComputer for HadoopGraph. Use HadoopGraph.compute(class) or gremlin.hadoop.defaultGraphComputer to specify the GraphComputer to use.");
    }

    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    public HadoopConfiguration configuration() {
        return this.configuration;
    }

    public String toString() {
        String fromString = this.configuration.containsKey("gremlin.hadoop.graphReader") ? this.configuration.getGraphReader().getSimpleName() : "no-reader";
        String toString = this.configuration.containsKey("gremlin.hadoop.graphWriter") ? this.configuration.getGraphWriter().getSimpleName() : "no-writer";
        return StringFactory.graphString((Graph)this, (String)(fromString.toLowerCase() + "->" + toString.toLowerCase()));
    }

    public void close() {
        this.configuration.clear();
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        try {
            if (0 == vertexIds.length) {
                return new HadoopVertexIterator(this);
            }
            if (vertexIds[0] instanceof Vertex) {
                if (!Stream.of(vertexIds).allMatch(id -> id instanceof Vertex)) {
                    throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
                }
                return Stream.of(vertexIds).map(id -> (Vertex)id).iterator();
            }
            Class<?> firstClass = vertexIds[0].getClass();
            if (!Stream.of(vertexIds).map(Object::getClass).allMatch(firstClass::equals)) {
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
            return IteratorUtils.filter((Iterator)new HadoopVertexIterator(this), vertex -> ElementHelper.idExists((Object)vertex.id(), (Object[])vertexIds));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        try {
            if (0 == edgeIds.length) {
                return new HadoopEdgeIterator(this);
            }
            if (edgeIds[0] instanceof Edge) {
                if (!Stream.of(edgeIds).allMatch(id -> id instanceof Edge)) {
                    throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
                }
                return Stream.of(edgeIds).map(id -> (Edge)id).iterator();
            }
            Class<?> firstClass = edgeIds[0].getClass();
            if (!Stream.of(edgeIds).map(Object::getClass).allMatch(firstClass::equals)) {
                throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
            }
            return IteratorUtils.filter((Iterator)new HadoopEdgeIterator(this), vertex -> ElementHelper.idExists((Object)vertex.id(), (Object[])edgeIds));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Graph.Features features() {
        return new HadoopGraphFeatures();
    }

    public static class HadoopGraphFeatures
    implements Graph.Features {
        public Graph.Features.GraphFeatures graph() {
            return new Graph.Features.GraphFeatures(){

                public boolean supportsTransactions() {
                    return false;
                }

                public boolean supportsThreadedTransactions() {
                    return false;
                }

                public Graph.Features.VariableFeatures variables() {
                    return new Graph.Features.VariableFeatures(){

                        public boolean supportsVariables() {
                            return false;
                        }

                        public boolean supportsBooleanValues() {
                            return false;
                        }

                        public boolean supportsByteValues() {
                            return false;
                        }

                        public boolean supportsDoubleValues() {
                            return false;
                        }

                        public boolean supportsFloatValues() {
                            return false;
                        }

                        public boolean supportsIntegerValues() {
                            return false;
                        }

                        public boolean supportsLongValues() {
                            return false;
                        }

                        public boolean supportsMapValues() {
                            return false;
                        }

                        public boolean supportsMixedListValues() {
                            return false;
                        }

                        public boolean supportsBooleanArrayValues() {
                            return false;
                        }

                        public boolean supportsByteArrayValues() {
                            return false;
                        }

                        public boolean supportsDoubleArrayValues() {
                            return false;
                        }

                        public boolean supportsFloatArrayValues() {
                            return false;
                        }

                        public boolean supportsIntegerArrayValues() {
                            return false;
                        }

                        public boolean supportsStringArrayValues() {
                            return false;
                        }

                        public boolean supportsLongArrayValues() {
                            return false;
                        }

                        public boolean supportsSerializableValues() {
                            return false;
                        }

                        public boolean supportsStringValues() {
                            return false;
                        }

                        public boolean supportsUniformListValues() {
                            return false;
                        }
                    };
                }
            };
        }

        public Graph.Features.EdgeFeatures edge() {
            return new Graph.Features.EdgeFeatures(){

                public boolean supportsAddEdges() {
                    return false;
                }

                public boolean supportsRemoveEdges() {
                    return false;
                }

                public boolean supportsAddProperty() {
                    return false;
                }

                public boolean supportsRemoveProperty() {
                    return false;
                }

                public boolean supportsCustomIds() {
                    return false;
                }
            };
        }

        public Graph.Features.VertexFeatures vertex() {
            return new Graph.Features.VertexFeatures(){

                public boolean supportsAddVertices() {
                    return false;
                }

                public boolean supportsRemoveVertices() {
                    return false;
                }

                public boolean supportsAddProperty() {
                    return false;
                }

                public boolean supportsRemoveProperty() {
                    return false;
                }

                public boolean supportsCustomIds() {
                    return false;
                }

                public Graph.Features.VertexPropertyFeatures properties() {
                    return new Graph.Features.VertexPropertyFeatures(){

                        public boolean supportsRemoveProperty() {
                            return false;
                        }

                        public boolean supportsCustomIds() {
                            return false;
                        }
                    };
                }
            };
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

