/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.GraphFilterAware;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class GraphFilterRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private GraphFilter graphFilter = null;
    private RecordReader<NullWritable, VertexWritable> recordReader;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        org.apache.hadoop.conf.Configuration configuration = taskAttemptContext.getConfiguration();
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)configuration.getClass("gremlin.hadoop.graphReader", InputFormat.class, InputFormat.class), (org.apache.hadoop.conf.Configuration)configuration);
        if (!(inputFormat instanceof GraphFilterAware) && configuration.get("gremlin.hadoop.graphFilter", null) != null) {
            this.graphFilter = (GraphFilter)VertexProgramHelper.deserialize((Configuration)ConfUtil.makeApacheConfiguration(configuration), (String)"gremlin.hadoop.graphFilter");
        }
        this.recordReader = inputFormat.createRecordReader(inputSplit, taskAttemptContext);
        this.recordReader.initialize(inputSplit, taskAttemptContext);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (null == this.graphFilter) {
            return this.recordReader.nextKeyValue();
        }
        while (this.recordReader.nextKeyValue()) {
            VertexWritable vertexWritable = (VertexWritable)this.recordReader.getCurrentValue();
            Optional vertex = vertexWritable.get().applyGraphFilter(this.graphFilter);
            if (!vertex.isPresent()) continue;
            vertexWritable.set((Vertex)vertex.get());
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() throws IOException, InterruptedException {
        return (VertexWritable)this.recordReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.recordReader.getProgress();
    }

    public void close() throws IOException {
        this.recordReader.close();
    }
}

