/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.VertexTerminator;
import org.apache.tinkerpop.gremlin.structure.io.util.IoRegistryHelper;

public final class GryoRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private FSDataInputStream inputStream;
    private static final byte[] PATTERN = GryoMapper.HEADER;
    private static final byte[] TERMINATOR = VertexTerminator.instance().terminal;
    private GryoReader gryoReader;
    private final VertexWritable vertexWritable = new VertexWritable();
    private long currentLength = 0L;
    private long splitLength;
    private GraphFilter graphFilter = new GraphFilter();

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        org.apache.hadoop.conf.Configuration configuration = context.getConfiguration();
        if (configuration.get("gremlin.hadoop.graphFilter", null) != null) {
            this.graphFilter = (GraphFilter)VertexProgramHelper.deserialize((Configuration)ConfUtil.makeApacheConfiguration(configuration), (String)"gremlin.hadoop.graphFilter");
        }
        this.gryoReader = GryoReader.build().mapper((Mapper)((GryoMapper.Builder)GryoMapper.build().addRegistries(IoRegistryHelper.createRegistries((Configuration)ConfUtil.makeApacheConfiguration(configuration)))).create()).create();
        long start = split.getStart();
        Path file = split.getPath();
        if (null != new CompressionCodecFactory(configuration).getCodec(file)) {
            throw new IllegalStateException("Compression is not supported for the (binary) Gryo format");
        }
        this.inputStream = file.getFileSystem(configuration).open(split.getPath());
        this.splitLength = split.getLength();
        if (this.splitLength > 0L) {
            this.splitLength -= GryoRecordReader.seekToHeader(this.inputStream, start) - start;
        }
    }

    private static long seekToHeader(FSDataInputStream inputStream, long start) throws IOException {
        inputStream.seek(start);
        long nextStart = start;
        byte[] buffer = new byte[PATTERN.length];
        while (true) {
            if ((buffer[0] = PATTERN[0]) == inputStream.readByte()) {
                inputStream.read(nextStart + 1L, buffer, 1, PATTERN.length - 1);
                if (!GryoRecordReader.patternMatch(buffer)) continue;
                inputStream.seek(nextStart);
                return nextStart;
            }
            inputStream.seek(++nextStart);
        }
    }

    private static boolean patternMatch(byte[] bytes) {
        for (int i = 0; i < PATTERN.length - 1; ++i) {
            if (bytes[i] == PATTERN[i]) continue;
            return false;
        }
        return true;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.currentLength >= this.splitLength) {
            return false;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        long currentVertexLength = 0L;
        int terminatorLocation = 0;
        while (true) {
            int currentByte;
            if (-1 == (currentByte = this.inputStream.read())) {
                if (currentVertexLength > 0L) {
                    throw new IllegalStateException("Remainder of stream exhausted without matching a vertex");
                }
                return false;
            }
            ++this.currentLength;
            ++currentVertexLength;
            output.write(currentByte);
            if ((terminatorLocation = (byte)currentByte == TERMINATOR[terminatorLocation] ? terminatorLocation + 1 : 0) < TERMINATOR.length) continue;
            ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
            Throwable throwable = null;
            try {
                Optional vertex = this.gryoReader.readVertex((InputStream)in, this.graphFilter);
                if (vertex.isPresent()) {
                    this.vertexWritable.set((Vertex)vertex.get());
                    boolean bl = true;
                    return bl;
                }
                currentVertexLength = 0L;
                terminatorLocation = 0;
                output.reset();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
                continue;
            }
            break;
        }
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() {
        return this.vertexWritable;
    }

    public float getProgress() throws IOException {
        return 0L == this.currentLength || 0L == this.splitLength ? 0.0f : (float)this.currentLength / (float)this.splitLength;
    }

    public synchronized void close() throws IOException {
        this.inputStream.close();
        this.gryoReader = null;
    }
}

