/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;

public final class ScriptRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    protected static final String SCRIPT_FILE = "gremlin.hadoop.scriptInputFormat.script";
    private static final String GRAPH = "graph";
    private static final String LINE = "line";
    private static final String FACTORY = "factory";
    private static final String READ_CALL = "parse(line,factory)";
    private final VertexWritable vertexWritable = new VertexWritable();
    private final LineRecordReader lineRecordReader;
    private ScriptEngine engine;
    private String parse;
    private CompiledScript script;
    private GraphFilter graphFilter = new GraphFilter();

    public ScriptRecordReader() {
        this.lineRecordReader = new LineRecordReader();
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
        org.apache.hadoop.conf.Configuration configuration = context.getConfiguration();
        if (configuration.get("gremlin.hadoop.graphFilter", null) != null) {
            this.graphFilter = (GraphFilter)VertexProgramHelper.deserialize((Configuration)ConfUtil.makeApacheConfiguration(configuration), (String)"gremlin.hadoop.graphFilter");
        }
        this.engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{new DefaultImportCustomizerProvider()});
        FileSystem fs = FileSystem.get((org.apache.hadoop.conf.Configuration)configuration);
        try (FSDataInputStream stream = fs.open(new Path(configuration.get(SCRIPT_FILE)));
             InputStreamReader reader = new InputStreamReader((InputStream)stream);){
            this.parse = String.join((CharSequence)"\n", IOUtils.toString((Reader)reader), READ_CALL);
            this.script = ((Compilable)((Object)this.engine)).compile(this.parse);
        }
        catch (ScriptException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public boolean nextKeyValue() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() {
        return this.vertexWritable;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }

    @Deprecated
    protected class ScriptElementFactory {
        private final StarGraph graph;

        public ScriptElementFactory() {
            this(StarGraph.open());
        }

        public ScriptElementFactory(StarGraph graph) {
            this.graph = graph;
        }

        public Vertex vertex(Object id) {
            return this.vertex(id, "vertex");
        }

        public Vertex vertex(Object id, String label) {
            Iterator vertices = this.graph.vertices(new Object[]{id});
            return vertices.hasNext() ? (Vertex)vertices.next() : this.graph.addVertex(new Object[]{T.id, id, T.label, label});
        }

        public Edge edge(Vertex out, Vertex in) {
            return this.edge(out, in, "edge");
        }

        public Edge edge(Vertex out, Vertex in, String label) {
            return out.addEdge(label, in, new Object[0]);
        }
    }
}

