/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.jsr223;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.script.SimpleBindings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.jsr223.HadoopRemoteAcceptor;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.mapreduce.MapReduceGraphComputer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopEdge;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopElement;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopProperty;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertexProperty;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.FileSystemStorage;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONRecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONRecordWriter;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoRecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoRecordWriter;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptRecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptRecordWriter;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.BindingsCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.DefaultImportCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.ImportCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.LazyBindingsCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.console.ConsoleCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.console.GremlinShellEnvironment;
import org.apache.tinkerpop.gremlin.jsr223.console.RemoteAcceptor;

public final class HadoopGremlinPlugin
extends AbstractGremlinPlugin {
    protected static String NAME = "tinkerpop.hadoop";
    private static final BindingsCustomizer bindings;
    private static final ImportCustomizer imports;
    private static final Set<String> appliesTo;
    private static final HadoopGremlinPlugin plugin;

    private HadoopGremlinPlugin() {
        super(NAME, appliesTo, new Customizer[]{imports, bindings, new HadoopConsoleCustomizer()});
    }

    public Optional<Customizer[]> getCustomizers(String scriptEngineName) {
        if (null == System.getenv("HADOOP_GREMLIN_LIBS")) {
            HadoopGraph.LOGGER.warn("Be sure to set the environmental variable: HADOOP_GREMLIN_LIBS");
        } else {
            HadoopGraph.LOGGER.info("HADOOP_GREMLIN_LIBS is set to: " + System.getenv("HADOOP_GREMLIN_LIBS"));
        }
        return super.getCustomizers(scriptEngineName);
    }

    public boolean requireRestart() {
        return true;
    }

    public static HadoopGremlinPlugin instance() {
        return plugin;
    }

    static {
        appliesTo = Collections.emptySet();
        try {
            imports = DefaultImportCustomizer.build().addClassImports(new Class[]{Configuration.class, DFSClient.class, FileSystem.class, ToolRunner.class, IOUtils.class, CodecPool.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Constants.class, HadoopConfiguration.class, HadoopEdge.class, HadoopElement.class, HadoopGraph.class, HadoopProperty.class, HadoopVertex.class, HadoopVertexProperty.class, ConfUtil.class, VertexWritable.class, GraphSONInputFormat.class, GraphSONOutputFormat.class, GraphSONRecordReader.class, GraphSONRecordWriter.class, GryoInputFormat.class, GryoOutputFormat.class, GryoRecordReader.class, GryoRecordWriter.class, ScriptInputFormat.class, ScriptOutputFormat.class, ScriptRecordReader.class, ScriptRecordWriter.class, MapReduceGraphComputer.class}).create();
            bindings = new LazyBindingsCustomizer(() -> {
                try {
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.put("hdfs", (Object)FileSystemStorage.open(FileSystem.get((Configuration)new Configuration())));
                    bindings.put("fs", (Object)FileSystemStorage.open((FileSystem)FileSystem.getLocal((Configuration)new Configuration())));
                    return bindings;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        plugin = new HadoopGremlinPlugin();
    }

    private static class HadoopConsoleCustomizer
    implements ConsoleCustomizer {
        private HadoopConsoleCustomizer() {
        }

        public RemoteAcceptor getRemoteAcceptor(GremlinShellEnvironment environment) {
            return new HadoopRemoteAcceptor(environment);
        }
    }
}

