/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;

public final class HadoopConfiguration
extends AbstractConfiguration
implements Serializable,
Iterable {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public HadoopConfiguration() {
        super.setDelimiterParsingDisabled(true);
    }

    public HadoopConfiguration(Configuration configuration) {
        this();
        this.copy(configuration);
    }

    protected void addPropertyDirect(String key, Object value) {
        this.properties.put(HadoopConfiguration.convertKey(key), value);
    }

    protected void clearPropertyDirect(String key) {
        this.properties.remove(HadoopConfiguration.convertKey(key));
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(HadoopConfiguration.convertKey(key));
    }

    public Object getProperty(String key) {
        return this.properties.get(HadoopConfiguration.convertKey(key));
    }

    public Iterator<String> getKeys() {
        return this.properties.keySet().iterator();
    }

    @Deprecated
    private static String convertKey(String key) {
        if (key.equals("gremlin.hadoop.graphInputFormat")) {
            return "gremlin.hadoop.graphReader";
        }
        if (key.equals("gremlin.hadoop.graphOutputFormat")) {
            return "gremlin.hadoop.graphWriter";
        }
        if (key.equals("gremlin.spark.graphInputRDD")) {
            return "gremlin.hadoop.graphReader";
        }
        if (key.equals("gremlin.spark.graphOutputRDD")) {
            return "gremlin.hadoop.graphWriter";
        }
        if (key.equals("gremlin.hadoop.graphInputFormat.hasEdges")) {
            return "gremlin.hadoop.graphReader.hasEdges";
        }
        if (key.equals("gremlin.hadoop.graphOutputFormat.hasEdges")) {
            return "gremlin.hadoop.graphWriter.hasEdges";
        }
        return key;
    }

    public <A> Class<A> getGraphReader() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphReader"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <A> Class<A> getGraphWriter() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphWriter"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public Class<InputFormat<NullWritable, VertexWritable>> getGraphInputFormat() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphReader"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public Class<OutputFormat<NullWritable, VertexWritable>> getGraphOutputFormat() {
        try {
            return Class.forName(this.getString("gremlin.hadoop.graphWriter"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getInputLocation() {
        return this.getString("gremlin.hadoop.inputLocation");
    }

    public void setInputLocation(String inputLocation) {
        this.setProperty("gremlin.hadoop.inputLocation", inputLocation);
    }

    public String getOutputLocation() {
        return this.getString("gremlin.hadoop.outputLocation");
    }

    public void setOutputLocation(String outputLocation) {
        this.setProperty("gremlin.hadoop.outputLocation", outputLocation);
    }

    public Iterator iterator() {
        return IteratorUtils.map(this.getKeys(), k -> new Pair(k, this.getProperty((String)k)));
    }
}

