/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.util.Collections;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoPool;

public final class HadoopPools {
    private static GryoPool GRYO_POOL = GryoPool.build().create();
    private static boolean INITIALIZED = false;

    private HadoopPools() {
    }

    public static synchronized void initialize(Configuration configuration) {
        if (!INITIALIZED) {
            INITIALIZED = true;
            GRYO_POOL = GryoPool.build().poolSize(configuration.getInt("gremlin.io.gryo.poolSize", 256)).ioRegistries(configuration.getList("gremlin.io.registry", Collections.emptyList())).initializeMapper(m -> m.registrationRequired(false)).create();
        }
    }

    public static synchronized void initialize(org.apache.hadoop.conf.Configuration configuration) {
        HadoopPools.initialize(ConfUtil.makeApacheConfiguration(configuration));
    }

    public static GryoPool getGryoPool() {
        if (!INITIALIZED) {
            HadoopGraph.LOGGER.warn("The " + HadoopPools.class.getSimpleName() + " has not been initialized, using the default pool");
            HadoopPools.initialize((Configuration)new BaseConfiguration());
        }
        return GRYO_POOL;
    }
}

