/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoOutputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptOutputFormat;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;

public final class InputOutputHelper {
    private static Map<Class<? extends InputFormat<NullWritable, VertexWritable>>, Class<? extends OutputFormat<NullWritable, VertexWritable>>> INPUT_TO_OUTPUT_CACHE = new ConcurrentHashMap<Class<? extends InputFormat<NullWritable, VertexWritable>>, Class<? extends OutputFormat<NullWritable, VertexWritable>>>();
    private static Map<Class<? extends OutputFormat<NullWritable, VertexWritable>>, Class<? extends InputFormat<NullWritable, VertexWritable>>> OUTPUT_TO_INPUT_CACHE = new ConcurrentHashMap<Class<? extends OutputFormat<NullWritable, VertexWritable>>, Class<? extends InputFormat<NullWritable, VertexWritable>>>();

    private InputOutputHelper() {
    }

    public static Class<? extends InputFormat> getInputFormat(Class<? extends OutputFormat<NullWritable, VertexWritable>> outputFormat) {
        return OUTPUT_TO_INPUT_CACHE.get(outputFormat);
    }

    public static Class<? extends OutputFormat> getOutputFormat(Class<? extends InputFormat<NullWritable, VertexWritable>> inputFormat) {
        return INPUT_TO_OUTPUT_CACHE.get(inputFormat);
    }

    public static void registerInputOutputPair(Class<? extends InputFormat<NullWritable, VertexWritable>> inputFormat, Class<? extends OutputFormat<NullWritable, VertexWritable>> outputFormat) {
        INPUT_TO_OUTPUT_CACHE.put(inputFormat, outputFormat);
        OUTPUT_TO_INPUT_CACHE.put(outputFormat, inputFormat);
    }

    public static HadoopGraph getOutputGraph(Configuration configuration, GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
        HadoopConfiguration hadoopConfiguration = new HadoopConfiguration(configuration);
        BaseConfiguration newConfiguration = new BaseConfiguration();
        newConfiguration.copy((Configuration)hadoopConfiguration);
        if (resultGraph.equals((Object)GraphComputer.ResultGraph.NEW)) {
            newConfiguration.setProperty("gremlin.hadoop.inputLocation", (Object)hadoopConfiguration.getOutputLocation());
            if (hadoopConfiguration.containsKey("gremlin.hadoop.graphWriter") && null != InputOutputHelper.getInputFormat(hadoopConfiguration.getGraphWriter())) {
                newConfiguration.setProperty("gremlin.hadoop.graphReader", (Object)InputOutputHelper.getInputFormat(hadoopConfiguration.getGraphWriter()).getCanonicalName());
            }
            newConfiguration.setProperty("gremlin.hadoop.graphReader.hasEdges", (Object)persist.equals((Object)GraphComputer.Persist.EDGES));
        }
        newConfiguration.setProperty("gremlin.hadoop.outputLocation", (Object)(hadoopConfiguration.getOutputLocation() + "_"));
        return HadoopGraph.open((Configuration)newConfiguration);
    }

    static {
        INPUT_TO_OUTPUT_CACHE.put(GryoInputFormat.class, GryoOutputFormat.class);
        INPUT_TO_OUTPUT_CACHE.put(GraphSONInputFormat.class, GraphSONOutputFormat.class);
        INPUT_TO_OUTPUT_CACHE.put(ScriptInputFormat.class, ScriptOutputFormat.class);
        OUTPUT_TO_INPUT_CACHE.put(GryoOutputFormat.class, GryoInputFormat.class);
        OUTPUT_TO_INPUT_CACHE.put(GraphSONOutputFormat.class, GraphSONInputFormat.class);
        OUTPUT_TO_INPUT_CACHE.put(ScriptOutputFormat.class, ScriptInputFormat.class);
    }
}

