/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopVertexIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HiddenFileFilter;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritableIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.TextIterator;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Storage;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class FileSystemStorage
implements Storage {
    private static final String SPACE = " ";
    private static final String D_SPACE = "(D) ";
    private static final String FORWARD_SLASH = "/";
    private static final String FORWARD_ASTERISK = "/*";
    private final FileSystem fs;

    private FileSystemStorage(FileSystem fileSystem) {
        this.fs = fileSystem;
    }

    public static FileSystemStorage open() {
        return FileSystemStorage.open(new org.apache.hadoop.conf.Configuration());
    }

    public static FileSystemStorage open(org.apache.hadoop.conf.Configuration configuration) {
        try {
            return new FileSystemStorage(FileSystem.get((org.apache.hadoop.conf.Configuration)configuration));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static FileSystemStorage open(FileSystem fileSystem) {
        return new FileSystemStorage(fileSystem);
    }

    private static String fileStatusString(FileStatus status) {
        StringBuilder s = new StringBuilder();
        s.append(status.getPermission()).append(SPACE);
        s.append(status.getOwner()).append(SPACE);
        s.append(status.getGroup()).append(SPACE);
        s.append(status.getLen()).append(SPACE);
        if (status.isDirectory()) {
            s.append(D_SPACE);
        }
        s.append(status.getPath().getName());
        return s.toString();
    }

    private String tryHomeDirectory(String location) {
        return location.equals(FORWARD_SLASH) ? this.fs.getHomeDirectory().toString() : location;
    }

    public List<String> ls() {
        return this.ls(FORWARD_SLASH);
    }

    public List<String> ls(String location) {
        try {
            return this.fs.isDirectory(new Path(this.tryHomeDirectory(location))) ? Stream.of(this.fs.globStatus(new Path(this.tryHomeDirectory(location) + FORWARD_ASTERISK))).map(FileSystemStorage::fileStatusString).collect(Collectors.toList()) : Stream.of(this.fs.globStatus(new Path(this.tryHomeDirectory(location) + "*"))).map(FileSystemStorage::fileStatusString).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean mkdir(String location) {
        try {
            return this.fs.mkdirs(new Path(location));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean cp(String sourceLocation, String targetLocation) {
        try {
            return FileUtil.copy((FileSystem)this.fs, (Path)new Path(sourceLocation), (FileSystem)this.fs, (Path)new Path(targetLocation), (boolean)false, (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean exists(String location) {
        try {
            return this.fs.globStatus(new Path(this.tryHomeDirectory(location) + "*")).length > 0;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean rm(String location) {
        try {
            FileStatus[] statuses = this.fs.globStatus(new Path(this.tryHomeDirectory(location) + "*"));
            Stream.of(statuses).forEach(status -> {
                try {
                    this.fs.delete(status.getPath(), true);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            });
            return statuses.length > 0;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Iterator<String> head(String location, int totalLines) {
        try {
            return IteratorUtils.limit((Iterator)new TextIterator(this.fs.getConf(), new Path(location)), (int)totalLines);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Iterator<Vertex> head(String location, Class readerClass, int totalLines) {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("gremlin.hadoop.inputLocation", (Object)Constants.getSearchGraphLocation(location, this).get());
        configuration.setProperty("gremlin.hadoop.graphReader", (Object)readerClass.getCanonicalName());
        try {
            if (InputFormat.class.isAssignableFrom(readerClass)) {
                return IteratorUtils.limit((Iterator)new HadoopVertexIterator(HadoopGraph.open((Configuration)configuration)), (int)totalLines);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        throw new IllegalArgumentException("The provided parser class must be an " + InputFormat.class.getCanonicalName() + ": " + readerClass.getCanonicalName());
    }

    public <K, V> Iterator<KeyValue<K, V>> head(String location, String memoryKey, Class readerClass, int totalLines) {
        if (!readerClass.equals(SequenceFileInputFormat.class)) {
            throw new IllegalArgumentException("Only " + SequenceFileInputFormat.class.getCanonicalName() + " memories are supported");
        }
        org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
        try {
            return IteratorUtils.limit((Iterator)new ObjectWritableIterator(configuration, new Path(Constants.getMemoryLocation(location, memoryKey))), (int)totalLines);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.storageString((String)this.fs.toString());
    }

    public void copyToLocal(String fromLocation, String toLocation) {
        try {
            this.fs.copyToLocalFile(new Path(fromLocation), new Path(toLocation));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void copyFromLocal(String fromLocation, String toLocation) {
        try {
            this.fs.copyFromLocalFile(new Path(fromLocation), new Path(toLocation));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void mergeToLocal(String fromLocation, String toLocation) {
        try {
            LocalFileSystem local = FileSystem.getLocal((org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
            FSDataOutputStream outA = local.create(new Path(toLocation));
            for (Path path : FileSystemStorage.getAllFilePaths(this.fs, new Path(fromLocation), HiddenFileFilter.instance())) {
                FSDataInputStream inA = this.fs.open(path);
                IOUtils.copyBytes((InputStream)inA, (OutputStream)outA, (int)8192);
                inA.close();
            }
            outA.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static List<Path> getAllFilePaths(FileSystem fs, Path path, PathFilter filter) throws IOException {
        if (null == path) {
            path = fs.getHomeDirectory();
        }
        if (path.toString().equals(FORWARD_SLASH)) {
            path = new Path("");
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        if (fs.isFile(path)) {
            paths.add(path);
        } else {
            for (FileStatus status : fs.globStatus(new Path(path + FORWARD_ASTERISK), filter)) {
                Path next = status.getPath();
                paths.addAll(FileSystemStorage.getAllFilePaths(fs, next, filter));
            }
        }
        return paths;
    }
}

