/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopProperty;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class HadoopVertexProperty<V>
implements VertexProperty<V>,
WrappedVertexProperty<VertexProperty<V>> {
    private final VertexProperty<V> baseVertexProperty;
    private final HadoopVertex hadoopVertex;

    public HadoopVertexProperty(VertexProperty<V> baseVertexProperty, HadoopVertex hadoopVertex) {
        this.baseVertexProperty = baseVertexProperty;
        this.hadoopVertex = hadoopVertex;
    }

    public Object id() {
        return this.baseVertexProperty.id();
    }

    public V value() {
        return (V)this.baseVertexProperty.value();
    }

    public String key() {
        return this.baseVertexProperty.key();
    }

    public void remove() {
        this.baseVertexProperty.remove();
    }

    public boolean isPresent() {
        return this.baseVertexProperty.isPresent();
    }

    public <U> Property<U> property(String key) {
        return this.baseVertexProperty.property(key);
    }

    public <U> Property<U> property(String key, U value) {
        throw Element.Exceptions.propertyAdditionNotSupported();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((VertexProperty)this, (Object)object);
    }

    public int hashCode() {
        return this.baseVertexProperty.hashCode();
    }

    public String toString() {
        return this.baseVertexProperty.toString();
    }

    public Vertex element() {
        return this.hadoopVertex;
    }

    public VertexProperty<V> getBaseVertexProperty() {
        return this.baseVertexProperty;
    }

    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        return IteratorUtils.map((Iterator)this.getBaseVertexProperty().properties(propertyKeys), property -> new HadoopProperty(property, (Element)this));
    }
}

