/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.PersistResultGraphAware;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.GraphComputerHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.Gremlin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHadoopGraphComputer
implements GraphComputer {
    private static final Pattern PATH_PATTERN = Pattern.compile(File.pathSeparator.equals(":") ? "([^:]|://)+" : "[^" + File.pathSeparator + "]");
    protected final Logger logger;
    protected final HadoopGraph hadoopGraph;
    protected boolean executed = false;
    protected final Set<MapReduce> mapReducers = new HashSet<MapReduce>();
    protected VertexProgram<Object> vertexProgram;
    protected int workers = 1;
    protected GraphComputer.ResultGraph resultGraph = null;
    protected GraphComputer.Persist persist = null;
    protected GraphFilter graphFilter = new GraphFilter();

    public AbstractHadoopGraphComputer(HadoopGraph hadoopGraph) {
        this.hadoopGraph = hadoopGraph;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public GraphComputer vertices(Traversal<Vertex, Vertex> vertexFilter) {
        this.graphFilter.setVertexFilter(vertexFilter);
        return this;
    }

    public GraphComputer edges(Traversal<Vertex, Edge> edgeFilter) {
        this.graphFilter.setEdgeFilter(edgeFilter);
        return this;
    }

    public GraphComputer result(GraphComputer.ResultGraph resultGraph) {
        this.resultGraph = resultGraph;
        return this;
    }

    public GraphComputer persist(GraphComputer.Persist persist) {
        this.persist = persist;
        return this;
    }

    public GraphComputer program(VertexProgram vertexProgram) {
        this.vertexProgram = vertexProgram;
        return this;
    }

    public GraphComputer mapReduce(MapReduce mapReduce) {
        this.mapReducers.add(mapReduce);
        return this;
    }

    public GraphComputer workers(int workers) {
        this.workers = workers;
        return this;
    }

    public String toString() {
        return StringFactory.graphComputerString((GraphComputer)this);
    }

    protected void validateStatePriorToExecution() {
        if (this.executed) {
            throw GraphComputer.Exceptions.computerHasAlreadyBeenSubmittedAVertexProgram();
        }
        this.executed = true;
        if (null == this.vertexProgram && this.mapReducers.isEmpty()) {
            throw GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers();
        }
        if (null != this.vertexProgram) {
            GraphComputerHelper.validateProgramOnComputer((GraphComputer)this, this.vertexProgram);
            this.mapReducers.addAll(this.vertexProgram.getMapReducers());
        }
        this.persist = GraphComputerHelper.getPersistState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.persist));
        this.resultGraph = GraphComputerHelper.getResultGraphState(Optional.ofNullable(this.vertexProgram), Optional.ofNullable(this.resultGraph));
        if (!this.features().supportsResultGraphPersistCombination(this.resultGraph, this.persist)) {
            throw GraphComputer.Exceptions.resultGraphPersistCombinationNotSupported((GraphComputer.ResultGraph)this.resultGraph, (GraphComputer.Persist)this.persist);
        }
        if (this.workers > this.features().getMaxWorkers()) {
            throw GraphComputer.Exceptions.computerRequiresMoreWorkersThanSupported((int)this.workers, (int)this.features().getMaxWorkers());
        }
    }

    protected void loadJars(org.apache.hadoop.conf.Configuration hadoopConfiguration, Object ... params) {
        if (hadoopConfiguration.getBoolean("gremlin.hadoop.jarsInDistributedCache", true)) {
            String hadoopGremlinLibs;
            String string = hadoopGremlinLibs = null == System.getProperty("HADOOP_GREMLIN_LIBS") ? System.getenv("HADOOP_GREMLIN_LIBS") : System.getProperty("HADOOP_GREMLIN_LIBS");
            if (null == hadoopGremlinLibs) {
                this.logger.warn("HADOOP_GREMLIN_LIBS is not set -- proceeding regardless");
            } else {
                try {
                    Matcher matcher = PATH_PATTERN.matcher(hadoopGremlinLibs);
                    while (matcher.find()) {
                        FileSystem fs;
                        String path = matcher.group();
                        try {
                            URI uri = new URI(path);
                            fs = FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)hadoopConfiguration);
                        }
                        catch (URISyntaxException e) {
                            fs = FileSystem.get((org.apache.hadoop.conf.Configuration)hadoopConfiguration);
                        }
                        File file = AbstractHadoopGraphComputer.copyDirectoryIfNonExistent(fs, path);
                        if (file.exists()) {
                            for (File f : file.listFiles()) {
                                if (!f.getName().endsWith(".jar")) continue;
                                this.loadJar(hadoopConfiguration, f, params);
                            }
                            continue;
                        }
                        this.logger.warn(path + " does not reference a valid directory -- proceeding regardless");
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }

    protected abstract void loadJar(org.apache.hadoop.conf.Configuration var1, File var2, Object ... var3) throws IOException;

    public Features features() {
        return new Features();
    }

    public static File copyDirectoryIfNonExistent(FileSystem fileSystem, String directory) {
        try {
            String hadoopGremlinLibsRemote = "hadoop-gremlin-" + Gremlin.version() + "-libs";
            Path path = new Path(directory);
            if (Boolean.valueOf(System.getProperty("is.testing", "false")).booleanValue() || fileSystem.exists(path) && fileSystem.isDirectory(path)) {
                File tempDirectory = new File(System.getProperty("java.io.tmpdir") + File.separator + hadoopGremlinLibsRemote);
                assert (tempDirectory.exists() || tempDirectory.mkdirs());
                String tempPath = tempDirectory.getAbsolutePath() + File.separator + path.getName();
                RemoteIterator files = fileSystem.listFiles(path, false);
                while (files.hasNext()) {
                    LocatedFileStatus f = (LocatedFileStatus)files.next();
                    fileSystem.copyToLocalFile(false, f.getPath(), new Path(tempPath + System.getProperty("file.separator") + f.getPath().getName()), true);
                }
                return new File(tempPath);
            }
            return new File(directory);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public class Features
    implements GraphComputer.Features {
        public boolean supportsVertexAddition() {
            return false;
        }

        public boolean supportsVertexRemoval() {
            return false;
        }

        public boolean supportsVertexPropertyRemoval() {
            return false;
        }

        public boolean supportsEdgeAddition() {
            return false;
        }

        public boolean supportsEdgeRemoval() {
            return false;
        }

        public boolean supportsEdgePropertyAddition() {
            return false;
        }

        public boolean supportsEdgePropertyRemoval() {
            return false;
        }

        public boolean supportsResultGraphPersistCombination(GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
            if (AbstractHadoopGraphComputer.this.hadoopGraph.configuration().containsKey("gremlin.hadoop.graphWriter")) {
                Object writer = ReflectionUtils.newInstance(AbstractHadoopGraphComputer.this.hadoopGraph.configuration().getGraphWriter(), (org.apache.hadoop.conf.Configuration)ConfUtil.makeHadoopConfiguration((Configuration)AbstractHadoopGraphComputer.this.hadoopGraph.configuration()));
                if (writer instanceof PersistResultGraphAware) {
                    return ((PersistResultGraphAware)writer).supportsResultGraphPersistCombination(resultGraph, persist);
                }
                AbstractHadoopGraphComputer.this.logger.warn(writer.getClass() + " does not implement " + PersistResultGraphAware.class.getSimpleName() + " and thus, persistence options are unknown -- assuming all options are possible");
                return true;
            }
            AbstractHadoopGraphComputer.this.logger.warn("No gremlin.hadoop.graphWriter property provided and thus, persistence options are unknown -- assuming all options are possible");
            return true;
        }

        public boolean supportsDirectObjects() {
            return false;
        }
    }
}

