/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ProductiveByStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class SampleTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Edge, Edge> get_g_E_sampleX1X();

    public abstract Traversal<Edge, Edge> get_g_E_sampleX2X_byXweightX();

    public abstract Traversal<Vertex, Edge> get_g_V_localXoutE_sampleX1X_byXweightXX();

    public abstract Traversal<Vertex, Map<String, Collection<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_sampleX2X_foldX();

    public abstract Traversal<Vertex, Map<String, Collection<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_fold_sampleXlocal_5XX();

    public abstract Traversal<Vertex, Object> get_g_VX1X_valuesXageX_sampleXlocal_5X(Object var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_sampleX1X() {
        Traversal<Edge, Edge> traversal = this.get_g_E_sampleX1X();
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_sampleX2X_byXweightX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_sampleX2X_byXweightX();
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.next();
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_localXoutE_sampleX1X_byXweightXX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_localXoutE_sampleX1X_byXweightXX();
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            traversal.next();
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXlabelX_byXbothE_weight_sampleX2X_foldX() {
        Traversal<Vertex, Map<String, Collection<Double>>> traversal = this.get_g_V_group_byXlabelX_byXbothE_weight_sampleX2X_foldX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)2L, (long)((Collection)map.get("software")).size());
        Assert.assertEquals((long)2L, (long)((Collection)map.get("person")).size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_group_byXlabelX_byXbothE_weight_fold_sampleXlocal_5XX() {
        Traversal<Vertex, Map<String, Collection<Double>>> traversal = this.get_g_V_group_byXlabelX_byXbothE_weight_fold_sampleXlocal_5XX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)4L, (long)((Collection)map.get("software")).size());
        Assert.assertEquals((long)5L, (long)((Collection)map.get("person")).size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_valuesXageX_sampleXlocal_5X() {
        Traversal<Vertex, Object> traversal = this.get_g_VX1X_valuesXageX_sampleXlocal_5X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        SampleTest.checkResults(Arrays.asList(29), traversal);
    }

    public static class Traversals
    extends SampleTest {
        @Override
        public Traversal<Edge, Edge> get_g_E_sampleX1X() {
            return this.g.E(new Object[0]).sample(1);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_sampleX2X_byXweightX() {
            return this.g.E(new Object[0]).sample(2).by("weight");
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_localXoutE_sampleX1X_byXweightXX() {
            return this.g.V(new Object[0]).local((Traversal)__.outE().sample(1).by("weight"));
        }

        @Override
        public Traversal<Vertex, Map<String, Collection<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_sampleX2X_foldX() {
            return this.g.V(new Object[0]).group().by(T.label).by((Traversal)__.bothE().values(new String[]{"weight"}).sample(2).fold());
        }

        @Override
        public Traversal<Vertex, Map<String, Collection<Double>>> get_g_V_group_byXlabelX_byXbothE_weight_fold_sampleXlocal_5XX() {
            return this.g.withoutStrategies(new Class[]{ProductiveByStrategy.class}).V(new Object[0]).group().by(T.label).by((Traversal)__.bothE().values(new String[]{"weight"}).fold().sample(Scope.local, 5));
        }

        @Override
        public Traversal<Vertex, Object> get_g_VX1X_valuesXageX_sampleXlocal_5X(Object vid1) {
            return this.g.V(new Object[]{vid1}).values(new String[]{"age"}).sample(Scope.local, 5);
        }
    }
}

