/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class TernaryBooleanLogicsTest
extends AbstractGremlinProcessTest {
    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareNaN() {
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.eq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.neq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte((Object)1.0)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareNull() {
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.eq(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.neq(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt(null)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.lte(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt(null)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.gte(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.eq(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.eq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.neq(null)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.neq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lt(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.lte(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lte((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gt(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is(P.gte(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gte((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.eq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.eq(null)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject(null).is(P.neq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.neq(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lt(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.lte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.lte(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gt((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gt(null)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject(null).is(P.gte((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{Double.NaN}).is(P.gte(null)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testCompareAcrossTypes() {
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.eq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.eq((Object)"foo")));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.neq((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.neq((Object)"foo")));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.lt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.lt((Object)"foo")));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.lte((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.lte((Object)"foo")));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.gt((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.gt((Object)"foo")));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new String[]{"foo"}).is((Object)P.gte((Object)1.0)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Double[]{1.0}).is((Object)P.gte((Object)"foo")));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testAnd() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)TRUE), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.and((Predicate)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)FALSE), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.and((Predicate)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).and(new Traversal[]{__.is((P)ERROR), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.and((Predicate)ERROR)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testOr() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)TRUE), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(TRUE.or((Predicate)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)FALSE), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(FALSE.or((Predicate)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)TRUE)}));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)FALSE)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).or(new Traversal[]{__.is((P)ERROR), __.is((P)ERROR)}));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is(ERROR.or((Predicate)ERROR)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testNot() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).is((Object)P.eq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).is((Object)P.neq((Object)Double.NaN)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)P.eq((Object)Double.NaN))));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.not((Traversal)__.is((P)P.eq((Object)Double.NaN)))));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).where((Traversal)__.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)ERROR))));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testXor() {
        P TRUE = P.eq((Object)1);
        P FALSE = P.gt((Object)1);
        P ERROR = P.lt((Object)Double.NaN);
        BiFunction<P, P, GraphTraversal> xor = (A, B) -> __.or((Traversal[])new Traversal[]{__.and((Traversal[])new Traversal[]{__.is((P)A), __.not((Traversal)__.is((P)B))}), __.and((Traversal[])new Traversal[]{__.is((P)B), __.not((Traversal)__.is((P)A))})});
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(TRUE, ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(FALSE, ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, TRUE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, FALSE)));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).filter((Traversal)xor.apply(ERROR, ERROR)));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="OrderabilitySemantics")
    public void testErrorPropagation() {
        P ERROR = P.lt((Object)Double.NaN);
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.not((Traversal)__.is((P)ERROR))));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.is((P)ERROR)));
        TernaryBooleanLogicsTest.checkHasNext(true, (Traversal)this.g.inject((Object[])new Integer[]{1}).not((Traversal)__.union((Traversal[])new Traversal[]{__.is((P)ERROR)})));
        TernaryBooleanLogicsTest.checkHasNext(false, (Traversal)this.g.inject((Object[])new Integer[]{1}).union(new Traversal[]{__.is((P)ERROR)}));
    }
}

