/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import java.io.File;
import java.net.Inet4Address;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbConfigKey;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdcFixture {
    private static final Logger logger = LoggerFactory.getLogger(KdcFixture.class);
    final String clientPassword = "123456";
    final String clientPassword2 = "1234562";
    final String userPassword = "password";
    final String clientPrincipalName = "drankye";
    final String clientPrincipalName2 = "drankye2";
    final String userPrincipalName = "stephen";
    final String serverPrincipalName = "test-service";
    final String ticketCacheFileName = "test-tkt.cc";
    final String ticketCacheFileName2 = "test-tkt2.cc";
    final String serviceKeytabFileName = "test-service.keytab";
    final String clientPrincipal;
    final String clientPrincipal2;
    final String serverPrincipal;
    final String userPrincipal;
    final File testDir;
    final File ticketCacheFile;
    final File ticketCacheFile2;
    final File serviceKeytabFile;
    final String gremlinHostname;
    final String kdcHostname;
    private SimpleKdcServer kdcServer;

    public KdcFixture(String moduleBaseDir) {
        this(moduleBaseDir, "localhost");
    }

    public KdcFixture(String moduleBaseDir, String kdcHostName) {
        this.kdcHostname = kdcHostName;
        this.gremlinHostname = this.findHostname();
        this.serverPrincipal = "test-service/" + this.gremlinHostname + "@TEST.COM";
        this.clientPrincipal = "drankye@TEST.COM";
        this.clientPrincipal2 = "drankye2@TEST.COM";
        this.userPrincipal = "stephen@TEST.COM";
        File targetDir = new File(moduleBaseDir, "target");
        this.testDir = new File(targetDir, "kdc");
        this.testDir.mkdirs();
        this.ticketCacheFile = new File(this.testDir, "test-tkt.cc");
        this.ticketCacheFile2 = new File(this.testDir, "test-tkt2.cc");
        this.serviceKeytabFile = new File(this.testDir, "test-service.keytab");
    }

    private String findHostname() {
        String hostname = "";
        try {
            hostname = Inet4Address.getLocalHost().getCanonicalHostName().toLowerCase();
        }
        catch (Exception e) {
            logger.error("Hostname not found: " + e.getMessage());
        }
        return hostname;
    }

    public void setUp() throws Exception {
        this.setUpKdcServer();
        this.setUpPrincipals();
    }

    private void setUpKdcServer() throws Exception {
        this.kdcServer = new TestKdcServer();
        this.kdcServer.setWorkDir(this.testDir);
        this.kdcServer.init();
        for (int ix = 0; ix < 10; ++ix) {
            try {
                this.kdcServer.start();
                break;
            }
            catch (Exception ex) {
                if (ix == 9) {
                    throw ex;
                }
                int pause = (ix + 1) * 1500;
                logger.warn(String.format("Failed to start Kerberos Server - pausing for %s milliseconds and trying again - try #%s", pause, ix + 1), (Throwable)ex);
                Thread.sleep(pause);
                continue;
            }
        }
    }

    private void setUpPrincipals() throws KrbException {
        this.kdcServer.createPrincipals(new String[]{this.serverPrincipal});
        this.kdcServer.exportPrincipal(this.serverPrincipal, this.serviceKeytabFile);
        this.kdcServer.createPrincipal(this.clientPrincipal, "123456");
        TgtTicket tgt = this.kdcServer.getKrbClient().requestTgt(this.clientPrincipal, "123456");
        this.kdcServer.getKrbClient().storeTicket(tgt, this.ticketCacheFile);
        this.kdcServer.createPrincipal(this.clientPrincipal2, "1234562");
        TgtTicket tgt2 = this.kdcServer.getKrbClient().requestTgt(this.clientPrincipal2, "1234562");
        this.kdcServer.getKrbClient().storeTicket(tgt2, this.ticketCacheFile2);
        this.kdcServer.createPrincipal(this.userPrincipal, "password");
    }

    public void close() {
        this.deletePrincipals();
        try {
            this.kdcServer.stop();
        }
        catch (KrbException krbex) {
            logger.warn("Tried to stop KdcServer but encountered an exception", (Throwable)krbex);
        }
        this.ticketCacheFile.delete();
        this.ticketCacheFile2.delete();
        this.serviceKeytabFile.delete();
        this.testDir.delete();
    }

    void deletePrincipals() {
        try {
            this.kdcServer.getKadmin().deleteBuiltinPrincipals();
        }
        catch (KrbException krbex) {
            logger.warn("Tried to delete builtin Principals on teardown but failed", (Throwable)krbex);
        }
        this.deletePrincipal(this.serverPrincipal);
        this.deletePrincipal(this.clientPrincipal);
        this.deletePrincipal(this.clientPrincipal2);
    }

    private void deletePrincipal(String principalToDelete) {
        try {
            this.kdcServer.deletePrincipal(principalToDelete);
        }
        catch (KrbException krbex) {
            logger.warn(String.format("Tried to delete %s Principals on teardown but failed", principalToDelete), (Throwable)krbex);
        }
    }

    public void createPrincipal(String principal) throws KrbException {
        this.kdcServer.createPrincipal(principal);
    }

    public static void main(String[] args) throws Exception {
        String projectBaseDir = args[0];
        KdcFixture kdcFixture = new KdcFixture(projectBaseDir, "0.0.0.0");
        kdcFixture.setUp();
        logger.info("KDC started with configuration {}/target/kdc/krb5.conf", (Object)projectBaseDir);
        while (true) {
            Thread.sleep(1000L);
        }
    }

    private class TestKdcServer
    extends SimpleKdcServer {
        public static final String KDC_REALM = "TEST.COM";
        public final String HOSTNAME;
        public static final int KDC_PORT = 4588;

        TestKdcServer() throws KrbException {
            this.HOSTNAME = KdcFixture.this.kdcHostname;
            this.setKdcRealm(KDC_REALM);
            this.setKdcHost(this.HOSTNAME);
            this.setAllowTcp(true);
            this.setAllowUdp(true);
            this.setKdcTcpPort(4588);
            this.setKdcUdpPort(4588);
            KrbClient krbClnt = this.getKrbClient();
            KrbConfig krbConfig = krbClnt.getKrbConfig();
            krbConfig.setString((ConfigKey)KrbConfigKey.PERMITTED_ENCTYPES, "aes128-cts-hmac-sha1-96 des-cbc-crc des-cbc-md5 des3-cbc-sha1");
            krbConfig.setString((ConfigKey)KrbConfigKey.DEFAULT_REALM, KDC_REALM);
            krbClnt.setTimeout(10000);
        }
    }
}

